/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;

public class StoreFileMetaData
implements Streamable {
    private String name;
    private long length;
    private String checksum;
    private org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version writtenBy;
    private BytesRef hash;

    private StoreFileMetaData() {
    }

    public StoreFileMetaData(String name, long length) {
        this(name, length, null);
    }

    public StoreFileMetaData(String name, long length, String checksum) {
        this(name, length, checksum, null, null);
    }

    public StoreFileMetaData(String name, long length, String checksum, org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version writtenBy) {
        this(name, length, checksum, writtenBy, null);
    }

    public StoreFileMetaData(String name, long length, String checksum, org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version writtenBy, BytesRef hash) {
        this.name = name;
        this.length = length;
        this.checksum = checksum;
        this.writtenBy = writtenBy;
        this.hash = hash == null ? new BytesRef() : hash;
    }

    public String name() {
        return this.name;
    }

    public long length() {
        return this.length;
    }

    @Nullable
    public String checksum() {
        return this.checksum;
    }

    public boolean isSame(StoreFileMetaData other) {
        if (this.checksum == null || other.checksum == null) {
            return false;
        }
        return this.length == other.length && this.checksum.equals(other.checksum) && this.hash.equals(other.hash);
    }

    public static StoreFileMetaData readStoreFileMetaData(StreamInput in) throws IOException {
        StoreFileMetaData md = new StoreFileMetaData();
        md.readFrom(in);
        return md;
    }

    public String toString() {
        return "name [" + this.name + "], length [" + this.length + "], checksum [" + this.checksum + "], writtenBy [" + this.writtenBy + "]";
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.length = in.readVLong();
        this.checksum = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_1_3_0)) {
            String versionString = in.readOptionalString();
            this.writtenBy = Lucene.parseVersionLenient(versionString, null);
        }
        this.hash = in.getVersion().onOrAfter(Version.V_1_3_3) ? in.readBytesRef() : new BytesRef();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.length);
        out.writeOptionalString(this.checksum);
        if (out.getVersion().onOrAfter(Version.V_1_3_0)) {
            out.writeOptionalString(this.writtenBy == null ? null : this.writtenBy.toString());
        }
        if (out.getVersion().onOrAfter(Version.V_1_3_3)) {
            out.writeBytesRef(this.hash);
        }
    }

    public org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version writtenBy() {
        return this.writtenBy;
    }

    public boolean hasLegacyChecksum() {
        return this.checksum != null && !(this.writtenBy != null && this.writtenBy.onOrAfter(org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version.LUCENE_4_8));
    }

    public BytesRef hash() {
        return this.hash;
    }
}

