/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.MMapDirectory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Constants;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.store.fs.DefaultFsIndexStoreModule;
import org.elasticsearch.index.store.fs.MmapFsIndexStoreModule;
import org.elasticsearch.index.store.fs.NioFsIndexStoreModule;
import org.elasticsearch.index.store.fs.SimpleFsIndexStoreModule;
import org.elasticsearch.index.store.ram.RamIndexStoreModule;

public class IndexStoreModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;

    public IndexStoreModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        Class indexStoreModule = NioFsIndexStoreModule.class;
        if ((Constants.WINDOWS || Constants.SUN_OS || Constants.LINUX) && Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            indexStoreModule = Constants.WINDOWS ? MmapFsIndexStoreModule.class : DefaultFsIndexStoreModule.class;
        } else if (Constants.WINDOWS) {
            indexStoreModule = SimpleFsIndexStoreModule.class;
        }
        String storeType = this.settings.get("index.store.type");
        if (Type.RAM.name().equalsIgnoreCase(storeType)) {
            indexStoreModule = RamIndexStoreModule.class;
        } else if (Type.MEMORY.match(storeType)) {
            indexStoreModule = RamIndexStoreModule.class;
        } else if (!Type.FS.match(storeType)) {
            if (Type.SIMPLEFS.match(storeType)) {
                indexStoreModule = SimpleFsIndexStoreModule.class;
            } else if (Type.NIOFS.match(storeType)) {
                indexStoreModule = NioFsIndexStoreModule.class;
            } else if (Type.MMAPFS.match(storeType)) {
                indexStoreModule = MmapFsIndexStoreModule.class;
            } else if (Type.DEFAULT.match(storeType)) {
                indexStoreModule = DefaultFsIndexStoreModule.class;
            } else if (storeType != null) {
                indexStoreModule = this.settings.getAsClass("index.store.type", indexStoreModule, "org.elasticsearch.index.store.", "IndexStoreModule");
            }
        }
        return ImmutableList.of(Modules.createModule(indexStoreModule, this.settings));
    }

    @Override
    protected void configure() {
    }

    public static enum Type {
        NIOFS{

            @Override
            public boolean match(String setting) {
                return super.match(setting) || "nio_fs".equalsIgnoreCase(setting);
            }
        }
        ,
        MMAPFS{

            @Override
            public boolean match(String setting) {
                return super.match(setting) || "mmap_fs".equalsIgnoreCase(setting);
            }
        }
        ,
        SIMPLEFS{

            @Override
            public boolean match(String setting) {
                return super.match(setting) || "simple_fs".equalsIgnoreCase(setting);
            }
        }
        ,
        RAM{

            @Override
            public boolean fsStore() {
                return false;
            }
        }
        ,
        MEMORY{

            @Override
            public boolean fsStore() {
                return false;
            }
        }
        ,
        FS,
        DEFAULT;


        public boolean fsStore() {
            return true;
        }

        public boolean match(String setting) {
            return this.name().equalsIgnoreCase(setting);
        }
    }
}

