/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.CompoundFileDirectory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.FileSwitchDirectory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.FilterDirectory;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.store.Store;

public final class DirectoryUtils {
    private DirectoryUtils() {
    }

    @Nullable
    public static Store.StoreDirectory getStoreDirectory(Directory dir) {
        Directory current = dir;
        while (true) {
            if (current instanceof Store.StoreDirectory) {
                return (Store.StoreDirectory)current;
            }
            if (current instanceof FilterDirectory) {
                current = ((FilterDirectory)current).getDelegate();
                continue;
            }
            if (!(current instanceof CompoundFileDirectory)) break;
            current = ((CompoundFileDirectory)current).getDirectory();
        }
        return null;
    }

    static final <T extends Directory> Directory getLeafDirectory(FilterDirectory dir, Class<T> targetClass) {
        Directory current = dir.getDelegate();
        while (current instanceof FilterDirectory && (targetClass == null || !targetClass.isAssignableFrom(current.getClass()))) {
            current = ((FilterDirectory)current).getDelegate();
        }
        return current;
    }

    public static <T extends Directory> T getLeaf(Directory dir, Class<T> targetClass) {
        return DirectoryUtils.getLeaf(dir, targetClass, null);
    }

    public static <T extends Directory> T getLeaf(Directory dir, Class<T> targetClass, T defaultValue) {
        Directory d = dir;
        if (dir instanceof FilterDirectory) {
            d = DirectoryUtils.getLeafDirectory((FilterDirectory)dir, targetClass);
        }
        if (d instanceof FileSwitchDirectory) {
            T leaf = DirectoryUtils.getLeaf(((FileSwitchDirectory)d).getPrimaryDir(), targetClass);
            d = leaf == null ? DirectoryUtils.getLeaf(((FileSwitchDirectory)d).getSecondaryDir(), targetClass, defaultValue) : leaf;
        }
        if (d != null && targetClass.isAssignableFrom(d.getClass())) {
            return (T)((Directory)targetClass.cast(d));
        }
        return defaultValue;
    }
}

