/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.Distribution;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.DistributionLL;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.DistributionSPL;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.IBSimilarity;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.Lambda;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.LambdaDF;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.LambdaTTF;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.Normalization;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.AbstractSimilarityProvider;

public class IBSimilarityProvider
extends AbstractSimilarityProvider {
    private static final ImmutableMap<String, Distribution> DISTRIBUTION_CACHE;
    private static final ImmutableMap<String, Lambda> LAMBDA_CACHE;
    private final IBSimilarity similarity;

    @Inject
    public IBSimilarityProvider(@Assisted String name, @Assisted Settings settings) {
        super(name);
        Distribution distribution = this.parseDistribution(settings);
        Lambda lambda = this.parseLambda(settings);
        Normalization normalization = this.parseNormalization(settings);
        this.similarity = new IBSimilarity(distribution, lambda, normalization);
    }

    protected Distribution parseDistribution(Settings settings) {
        String rawDistribution = settings.get("distribution");
        Distribution distribution = DISTRIBUTION_CACHE.get(rawDistribution);
        if (distribution == null) {
            throw new ElasticsearchIllegalArgumentException("Unsupported Distribution [" + rawDistribution + "]");
        }
        return distribution;
    }

    protected Lambda parseLambda(Settings settings) {
        String rawLambda = settings.get("lambda");
        Lambda lambda = LAMBDA_CACHE.get(rawLambda);
        if (lambda == null) {
            throw new ElasticsearchIllegalArgumentException("Unsupported Lambda [" + rawLambda + "]");
        }
        return lambda;
    }

    @Override
    public Similarity get() {
        return this.similarity;
    }

    static {
        MapBuilder<String, Distribution> distributions = MapBuilder.newMapBuilder();
        distributions.put("ll", new DistributionLL());
        distributions.put("spl", new DistributionSPL());
        DISTRIBUTION_CACHE = distributions.immutableMap();
        MapBuilder<String, Lambda> lamdas = MapBuilder.newMapBuilder();
        lamdas.put("df", new LambdaDF());
        lamdas.put("ttf", new LambdaTTF());
        LAMBDA_CACHE = lamdas.immutableMap();
    }
}

