/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

public class InMemoryGeoBoundingBoxFilter
extends Filter {
    private final GeoPoint topLeft;
    private final GeoPoint bottomRight;
    private final IndexGeoPointFieldData indexFieldData;

    public InMemoryGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, IndexGeoPointFieldData indexFieldData) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.indexFieldData = indexFieldData;
    }

    public GeoPoint topLeft() {
        return this.topLeft;
    }

    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
        MultiGeoPointValues values = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        if (this.topLeft.lon() > this.bottomRight.lon()) {
            return new Meridian180GeoBoundingBoxDocSet(context.reader().maxDoc(), acceptedDocs, values, this.topLeft, this.bottomRight);
        }
        return new GeoBoundingBoxDocSet(context.reader().maxDoc(), acceptedDocs, values, this.topLeft, this.bottomRight);
    }

    public String toString() {
        return "GeoBoundingBoxFilter(" + this.indexFieldData.getFieldNames().indexName() + ", " + this.topLeft + ", " + this.bottomRight + ")";
    }

    public static class GeoBoundingBoxDocSet
    extends MatchDocIdSet {
        private final MultiGeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public GeoBoundingBoxDocSet(int maxDoc, @Nullable Bits acceptDocs, MultiGeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        protected boolean matchDoc(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.values.valueAt(i);
                if (!(this.topLeft.lon() <= point.lon()) || !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                return true;
            }
            return false;
        }
    }

    public static class Meridian180GeoBoundingBoxDocSet
    extends MatchDocIdSet {
        private final MultiGeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public Meridian180GeoBoundingBoxDocSet(int maxDoc, @Nullable Bits acceptDocs, MultiGeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        protected boolean matchDoc(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.values.valueAt(i);
                if (!(this.topLeft.lon() <= point.lon()) && !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                return true;
            }
            return false;
        }
    }
}

