/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

public class GeoPolygonFilter
extends Filter {
    private final GeoPoint[] points;
    private final IndexGeoPointFieldData indexFieldData;

    public GeoPolygonFilter(IndexGeoPointFieldData indexFieldData, GeoPoint ... points) {
        this.points = points;
        this.indexFieldData = indexFieldData;
    }

    public GeoPoint[] points() {
        return this.points;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
        MultiGeoPointValues values = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        return new GeoPolygonDocIdSet(context.reader().maxDoc(), acceptedDocs, values, this.points);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GeoPolygonFilter(");
        sb.append(this.indexFieldData.getFieldNames().indexName());
        sb.append(", ").append(Arrays.toString(this.points)).append(')');
        return sb.toString();
    }

    public static class GeoPolygonDocIdSet
    extends MatchDocIdSet {
        private final MultiGeoPointValues values;
        private final GeoPoint[] points;

        public GeoPolygonDocIdSet(int maxDoc, @Nullable Bits acceptDocs, MultiGeoPointValues values, GeoPoint[] points) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.points = points;
        }

        @Override
        protected boolean matchDoc(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.values.valueAt(i);
                if (!GeoPolygonDocIdSet.pointInPolygon(this.points, point.lat(), point.lon())) continue;
                return true;
            }
            return false;
        }

        private static boolean pointInPolygon(GeoPoint[] points, double lat, double lon) {
            boolean inPoly = false;
            for (int i = 1; i < points.length; ++i) {
                if (!(points[i].lon() < lon && points[i - 1].lon() >= lon) && (!(points[i - 1].lon() < lon) || !(points[i].lon() >= lon)) || !(points[i].lat() + (lon - points[i].lon()) / (points[i - 1].lon() - points[i].lon()) * (points[i - 1].lat() - points[i].lat()) < lat)) continue;
                inPoly = !inPoly;
            }
            return inPoly;
        }
    }
}

