/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.docset.AndDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxFilter;

public class GeoDistanceRangeFilter
extends Filter {
    private final double lat;
    private final double lon;
    private final double inclusiveLowerPoint;
    private final double inclusiveUpperPoint;
    private final GeoDistance geoDistance;
    private final GeoDistance.FixedSourceDistance fixedSourceDistance;
    private GeoDistance.DistanceBoundingCheck distanceBoundingCheck;
    private final Filter boundingBoxFilter;
    private final IndexGeoPointFieldData indexFieldData;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoDistanceRangeFilter(GeoPoint point, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper, GeoDistance geoDistance, GeoPointFieldMapper mapper, IndexGeoPointFieldData indexFieldData, String optimizeBbox) {
        long i;
        double f;
        this.lat = point.lat();
        this.lon = point.lon();
        this.geoDistance = geoDistance;
        this.indexFieldData = indexFieldData;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(this.lat, this.lon, DistanceUnit.DEFAULT);
        if (lowerVal != null) {
            f = lowerVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveLowerPoint = NumericUtils.sortableLongToDouble(includeLower ? i : i + 1L);
        } else {
            this.inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
        }
        if (upperVal != null) {
            f = upperVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveUpperPoint = NumericUtils.sortableLongToDouble(includeUpper ? i : i - 1L);
        } else {
            this.inclusiveUpperPoint = Double.POSITIVE_INFINITY;
            optimizeBbox = null;
        }
        if (optimizeBbox != null && !"none".equals(optimizeBbox)) {
            this.distanceBoundingCheck = GeoDistance.distanceBoundingCheck(this.lat, this.lon, this.inclusiveUpperPoint, DistanceUnit.DEFAULT);
            if ("memory".equals(optimizeBbox)) {
                this.boundingBoxFilter = null;
                return;
            } else {
                if (!"indexed".equals(optimizeBbox)) throw new ElasticsearchIllegalArgumentException("type [" + optimizeBbox + "] for bounding box optimization not supported");
                this.boundingBoxFilter = IndexedGeoBoundingBoxFilter.create(this.distanceBoundingCheck.topLeft(), this.distanceBoundingCheck.bottomRight(), mapper);
                this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            }
            return;
        } else {
            this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            this.boundingBoxFilter = null;
        }
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
        DocIdSet boundingBoxDocSet = null;
        if (this.boundingBoxFilter != null && DocIdSets.isEmpty(boundingBoxDocSet = this.boundingBoxFilter.getDocIdSet(context, acceptedDocs))) {
            return null;
        }
        MultiGeoPointValues values = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        GeoDistanceRangeDocSet distDocSet = new GeoDistanceRangeDocSet(context.reader().maxDoc(), acceptedDocs, values, this.fixedSourceDistance, this.distanceBoundingCheck, this.inclusiveLowerPoint, this.inclusiveUpperPoint);
        if (boundingBoxDocSet == null) {
            return distDocSet;
        }
        return new AndDocIdSet(new DocIdSet[]{boundingBoxDocSet, distDocSet});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceRangeFilter filter = (GeoDistanceRangeFilter)o;
        if (Double.compare(filter.inclusiveLowerPoint, this.inclusiveLowerPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.inclusiveUpperPoint, this.inclusiveUpperPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (!this.indexFieldData.getFieldNames().indexName().equals(filter.indexFieldData.getFieldNames().indexName())) {
            return false;
        }
        return this.geoDistance == filter.geoDistance;
    }

    public String toString() {
        return "GeoDistanceRangeFilter(" + this.indexFieldData.getFieldNames().indexName() + ", " + (Object)((Object)this.geoDistance) + ", [" + this.inclusiveLowerPoint + " - " + this.inclusiveUpperPoint + "], " + this.lat + ", " + this.lon + ")";
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveLowerPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveLowerPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveUpperPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveUpperPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result = 31 * result + this.indexFieldData.getFieldNames().indexName().hashCode();
        return result;
    }

    public static class GeoDistanceRangeDocSet
    extends MatchDocIdSet {
        private final MultiGeoPointValues values;
        private final GeoDistance.FixedSourceDistance fixedSourceDistance;
        private final GeoDistance.DistanceBoundingCheck distanceBoundingCheck;
        private final double inclusiveLowerPoint;
        private final double inclusiveUpperPoint;

        public GeoDistanceRangeDocSet(int maxDoc, @Nullable Bits acceptDocs, MultiGeoPointValues values, GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistance.DistanceBoundingCheck distanceBoundingCheck, double inclusiveLowerPoint, double inclusiveUpperPoint) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.fixedSourceDistance = fixedSourceDistance;
            this.distanceBoundingCheck = distanceBoundingCheck;
            this.inclusiveLowerPoint = inclusiveLowerPoint;
            this.inclusiveUpperPoint = inclusiveUpperPoint;
        }

        @Override
        protected boolean matchDoc(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                double d;
                GeoPoint point = this.values.valueAt(i);
                if (!this.distanceBoundingCheck.isWithin(point.lat(), point.lon()) || !((d = this.fixedSourceDistance.calculate(point.lat(), point.lon())) >= this.inclusiveLowerPoint) || !(d <= this.inclusiveUpperPoint)) continue;
                return true;
            }
            return false;
        }
    }
}

