/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.search.EmptyScorer;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

@Deprecated
public class TopChildrenQuery
extends Query {
    private static final ParentDocComparator PARENT_DOC_COMP = new ParentDocComparator();
    private final IndexParentChildFieldData parentChildIndexFieldData;
    private final CacheRecycler cacheRecycler;
    private final String parentType;
    private final String childType;
    private final ScoreType scoreType;
    private final int factor;
    private final int incrementalFactor;
    private Query originalChildQuery;
    private final FixedBitSetFilter nonNestedDocsFilter;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public TopChildrenQuery(IndexParentChildFieldData parentChildIndexFieldData, Query childQuery, String childType, String parentType, ScoreType scoreType, int factor, int incrementalFactor, CacheRecycler cacheRecycler, FixedBitSetFilter nonNestedDocsFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.originalChildQuery = childQuery;
        this.childType = childType;
        this.parentType = parentType;
        this.scoreType = scoreType;
        this.factor = factor;
        this.incrementalFactor = incrementalFactor;
        this.cacheRecycler = cacheRecycler;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    @Override
    public Query clone() {
        TopChildrenQuery q = (TopChildrenQuery)super.clone();
        q.originalChildQuery = this.originalChildQuery.clone();
        if (q.rewrittenChildQuery != null) {
            q.rewrittenChildQuery = this.rewrittenChildQuery.clone();
        }
        return q;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Query childQuery;
        Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs = this.cacheRecycler.hashMap(-1);
        SearchContext searchContext = SearchContext.current();
        int requestedDocs = searchContext.from() + searchContext.size();
        if (requestedDocs <= 0) {
            requestedDocs = 1;
        }
        int numChildDocs = requestedDocs * this.factor;
        if (this.rewrittenChildQuery == null) {
            childQuery = this.rewrittenChildQuery = searcher.rewrite(this.originalChildQuery);
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader()) : "not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader();
            childQuery = this.rewrittenChildQuery;
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.setSimilarity(searcher.getSimilarity());
        while (true) {
            int parentHitsResolved;
            parentDocs.v().clear();
            TopDocs topChildDocs = indexSearcher.search(childQuery, numChildDocs);
            try {
                parentHitsResolved = this.resolveParentDocuments(topChildDocs, searchContext, parentDocs);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (parentHitsResolved >= requestedDocs || topChildDocs.totalHits <= numChildDocs) break;
            if ((numChildDocs *= this.incrementalFactor) <= topChildDocs.totalHits) continue;
            numChildDocs = topChildDocs.totalHits;
        }
        ParentWeight parentWeight = new ParentWeight(this.rewrittenChildQuery.createWeight(searcher), parentDocs);
        searchContext.addReleasable(parentWeight, SearchContext.Lifetime.COLLECTION);
        return parentWeight;
    }

    int resolveParentDocuments(TopDocs topDocs, SearchContext context, Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs) throws Exception {
        int parentHitsResolved = 0;
        Recycler.V parentDocsPerReader = this.cacheRecycler.hashMap(context.searcher().getIndexReader().leaves().size());
        block0: for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            int subDoc;
            int readerIndex = ReaderUtil.subIndex(scoreDoc.doc, context.searcher().getIndexReader().leaves());
            AtomicReaderContext subContext = context.searcher().getIndexReader().leaves().get(readerIndex);
            SortedDocValues parentValues = ((AtomicParentChildFieldData)this.parentChildIndexFieldData.load(subContext)).getOrdinalsValues(this.parentType);
            BytesRef parentId = parentValues.get(subDoc = scoreDoc.doc - subContext.docBase);
            if (parentId == null) continue;
            for (AtomicReaderContext atomicReaderContext : context.searcher().getIndexReader().leaves()) {
                ParentDoc parentDoc;
                TermsEnum termsEnum;
                Terms terms;
                AtomicReader indexReader = atomicReaderContext.reader();
                FixedBitSet nonNestedDocs = null;
                if (this.nonNestedDocsFilter != null) {
                    nonNestedDocs = this.nonNestedDocsFilter.getDocIdSet(atomicReaderContext, indexReader.getLiveDocs());
                }
                if ((terms = indexReader.terms("_uid")) == null || !(termsEnum = terms.iterator(null)).seekExact(Uid.createUidAsBytes(this.parentType, parentId))) continue;
                DocsEnum docsEnum = termsEnum.docs(indexReader.getLiveDocs(), null, 0);
                int parentDocId = docsEnum.nextDoc();
                if (nonNestedDocs != null && !nonNestedDocs.get(parentDocId)) {
                    parentDocId = nonNestedDocs.nextSetBit(parentDocId);
                }
                if (parentDocId == Integer.MAX_VALUE) continue;
                Recycler.V readerParentDocs = (Recycler.V)parentDocsPerReader.v().get(indexReader.getCoreCacheKey());
                if (readerParentDocs == null) {
                    int mapSize = Math.min(indexReader.maxDoc(), context.from() + context.size());
                    readerParentDocs = this.cacheRecycler.intObjectMap(mapSize);
                    parentDocsPerReader.v().put(indexReader.getCoreCacheKey(), readerParentDocs);
                }
                if ((parentDoc = (ParentDoc)((IntObjectOpenHashMap)readerParentDocs.v()).get(parentDocId)) == null) {
                    ++parentHitsResolved;
                    parentDoc = new ParentDoc();
                    parentDoc.docId = parentDocId;
                    parentDoc.count = 1;
                    parentDoc.maxScore = scoreDoc.score;
                    parentDoc.minScore = scoreDoc.score;
                    parentDoc.sumScores = scoreDoc.score;
                    readerParentDocs.v().put(parentDocId, parentDoc);
                    continue block0;
                }
                ++parentDoc.count;
                parentDoc.sumScores += scoreDoc.score;
                if (scoreDoc.score < parentDoc.minScore) {
                    parentDoc.minScore = scoreDoc.score;
                }
                if (!(scoreDoc.score > parentDoc.maxScore)) continue block0;
                parentDoc.maxScore = scoreDoc.score;
                continue block0;
            }
        }
        boolean[] states = parentDocsPerReader.v().allocated;
        KType[] keys = parentDocsPerReader.v().keys;
        VType[] values = parentDocsPerReader.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            Recycler.V value = (Recycler.V)values[i];
            ParentDoc[] _parentDocs = ((IntObjectOpenHashMap)value.v()).values().toArray(ParentDoc.class);
            Arrays.sort(_parentDocs, PARENT_DOC_COMP);
            parentDocs.v().put(keys[i], _parentDocs);
            Releasables.close(value);
        }
        Releasables.close(parentDocsPerReader);
        return parentHitsResolved;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TopChildrenQuery that = (TopChildrenQuery)obj;
        if (!this.originalChildQuery.equals(that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        if (this.incrementalFactor != that.incrementalFactor) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    @Override
    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + this.incrementalFactor;
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("score_child[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery.toString(field)).append(')');
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    private static class ParentDoc {
        public int docId;
        public int count;
        public float minScore = Float.NaN;
        public float maxScore = Float.NaN;
        public float sumScores = 0.0f;

        private ParentDoc() {
        }
    }

    private static class ParentDocComparator
    implements Comparator<ParentDoc> {
        private ParentDocComparator() {
        }

        @Override
        public int compare(ParentDoc o1, ParentDoc o2) {
            return o1.docId - o2.docId;
        }
    }

    private static abstract class ParentScorer
    extends Scorer {
        private final ParentDoc spare;
        protected final ParentDoc[] docs;
        protected ParentDoc doc;
        private int index;

        ParentScorer(ParentWeight weight, ParentDoc[] docs) throws IOException {
            super(weight);
            this.doc = this.spare = new ParentDoc();
            this.index = -1;
            this.docs = docs;
            this.spare.docId = -1;
            this.spare.count = -1;
        }

        @Override
        public final int docID() {
            return this.doc.docId;
        }

        @Override
        public final int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public final int nextDoc() throws IOException {
            if (++this.index >= this.docs.length) {
                this.doc = this.spare;
                this.doc.count = 0;
                this.doc.docId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = this.docs[this.index];
            return this.doc.docId;
        }

        @Override
        public final int freq() throws IOException {
            return this.doc.count;
        }

        @Override
        public final long cost() {
            return this.docs.length;
        }
    }

    private class ParentWeight
    extends Weight
    implements Releasable {
        private final Weight queryWeight;
        private final Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs;

        public ParentWeight(Weight queryWeight, Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs) throws IOException {
            this.queryWeight = queryWeight;
            this.parentDocs = parentDocs;
        }

        @Override
        public Query getQuery() {
            return TopChildrenQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float sum = this.queryWeight.getValueForNormalization();
            return sum *= TopChildrenQuery.this.getBoost() * TopChildrenQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentDocs);
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            ParentDoc[] readerParentDocs = this.parentDocs.v().get(context.reader().getCoreCacheKey());
            if (readerParentDocs != null) {
                if (TopChildrenQuery.this.scoreType == ScoreType.MIN) {
                    return new ParentScorer(this, readerParentDocs){

                        @Override
                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 && this.doc.docId != Integer.MAX_VALUE);
                            return this.doc.minScore;
                        }
                    };
                }
                if (TopChildrenQuery.this.scoreType == ScoreType.MAX) {
                    return new ParentScorer(this, readerParentDocs){

                        @Override
                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 && this.doc.docId != Integer.MAX_VALUE);
                            return this.doc.maxScore;
                        }
                    };
                }
                if (TopChildrenQuery.this.scoreType == ScoreType.AVG) {
                    return new ParentScorer(this, readerParentDocs){

                        @Override
                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 && this.doc.docId != Integer.MAX_VALUE);
                            return this.doc.sumScores / (float)this.doc.count;
                        }
                    };
                }
                if (TopChildrenQuery.this.scoreType == ScoreType.SUM) {
                    return new ParentScorer(this, readerParentDocs){

                        @Override
                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 && this.doc.docId != Integer.MAX_VALUE);
                            return this.doc.sumScores;
                        }
                    };
                }
                throw new ElasticsearchIllegalStateException("No support for score type [" + (Object)((Object)TopChildrenQuery.this.scoreType) + "]");
            }
            return new EmptyScorer(this);
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(TopChildrenQuery.this.getBoost(), "not implemented yet...");
        }
    }
}

