/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.search.internal.SearchContext;

public class ParentQuery
extends Query {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query originalParentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private Query rewrittenParentQuery;
    private IndexReader rewriteIndexReader;

    public ParentQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query parentQuery, String parentType, Filter childrenFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.originalParentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ParentQuery that = (ParentQuery)obj;
        if (!this.originalParentQuery.equals(that.originalParentQuery)) {
            return false;
        }
        if (!this.parentType.equals(that.parentType)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    @Override
    public int hashCode() {
        int result = this.originalParentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    @Override
    public String toString(String field) {
        return "ParentQuery[" + this.parentType + "](" + this.originalParentQuery.toString(field) + ')' + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenParentQuery == null) {
            this.rewriteIndexReader = reader;
            this.rewrittenParentQuery = this.originalParentQuery.rewrite(reader);
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.rewrittenParentQuery.extractTerms(terms);
    }

    @Override
    public Query clone() {
        ParentQuery q = (ParentQuery)super.clone();
        q.originalParentQuery = this.originalParentQuery.clone();
        if (q.rewrittenParentQuery != null) {
            q.rewrittenParentQuery = this.rewrittenParentQuery.clone();
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        block8: {
            block9: {
                sc = SearchContext.current();
                releaseCollectorResource = true;
                collector = null;
                globalIfd = this.parentChildIndexFieldData.loadGlobal(searcher.getIndexReader());
                if (globalIfd == null) {
                    return Queries.newMatchNoDocsQuery().createWeight(searcher);
                }
                try {
                    if (!ParentQuery.$assertionsDisabled && this.rewrittenParentQuery == null) {
                        throw new AssertionError();
                    }
                    if (!ParentQuery.$assertionsDisabled && this.rewriteIndexReader != searcher.getIndexReader()) {
                        throw new AssertionError((Object)("not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader()));
                    }
                    parentQuery = this.rewrittenParentQuery;
                    collector = new ParentOrdAndScoreCollector(sc, globalIfd, this.parentType);
                    indexSearcher = new IndexSearcher(sc.searcher().getIndexReader());
                    indexSearcher.setSimilarity(searcher.getSimilarity());
                    indexSearcher.search(parentQuery, collector);
                    if (collector.parentCount() != 0L) break block8;
                    var8_8 = Queries.newMatchNoDocsQuery().createWeight(searcher);
                    if (!releaseCollectorResource) break block9;
                }
                catch (Throwable var10_10) {
                    if (releaseCollectorResource) {
                        Releasables.close(new Releasable[]{collector});
                    }
                    throw var10_10;
                }
                Releasables.close(new Releasable[]{collector});
            }
            return var8_8;
        }
        childWeight = new ChildWeight(parentQuery.createWeight(searcher), this.childrenFilter, collector, globalIfd);
        releaseCollectorResource = false;
        ** if (!releaseCollectorResource) goto lbl34
lbl-1000:
        // 1 sources

        {
            Releasables.close(new Releasable[]{collector});
        }
        {
        }
lbl34:
        // 2 sources

        sc.addReleasable(collector, SearchContext.Lifetime.COLLECTION);
        return childWeight;
    }

    private static class ChildScorer
    extends Scorer {
        private final LongHash parentIdxs;
        private final FloatArray scores;
        private final DocIdSetIterator childrenIterator;
        private final SortedDocValues ordinals;
        private int currentChildDoc = -1;
        private float currentScore;

        ChildScorer(Weight weight, LongHash parentIdxs, FloatArray scores, DocIdSetIterator childrenIterator, SortedDocValues ordinals) {
            super(weight);
            this.parentIdxs = parentIdxs;
            this.scores = scores;
            this.childrenIterator = childrenIterator;
            this.ordinals = ordinals;
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public int docID() {
            return this.currentChildDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            long parentIdx;
            int globalOrdinal;
            do {
                this.currentChildDoc = this.childrenIterator.nextDoc();
                if (this.currentChildDoc != Integer.MAX_VALUE) continue;
                return this.currentChildDoc;
            } while ((globalOrdinal = this.ordinals.getOrd(this.currentChildDoc)) < 0 || (parentIdx = this.parentIdxs.find(globalOrdinal)) == -1L);
            this.currentScore = this.scores.get(parentIdx);
            return this.currentChildDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.currentChildDoc = this.childrenIterator.advance(target);
            if (this.currentChildDoc == Integer.MAX_VALUE) {
                return this.currentChildDoc;
            }
            int globalOrdinal = this.ordinals.getOrd(this.currentChildDoc);
            if (globalOrdinal < 0) {
                return this.nextDoc();
            }
            long parentIdx = this.parentIdxs.find(globalOrdinal);
            if (parentIdx != -1L) {
                this.currentScore = this.scores.get(parentIdx);
                return this.currentChildDoc;
            }
            return this.nextDoc();
        }

        @Override
        public long cost() {
            return this.childrenIterator.cost();
        }
    }

    private class ChildWeight
    extends Weight {
        private final Weight parentWeight;
        private final Filter childrenFilter;
        private final LongHash parentIdxs;
        private final FloatArray scores;
        private final IndexParentChildFieldData globalIfd;

        private ChildWeight(Weight parentWeight, Filter childrenFilter, ParentOrdAndScoreCollector collector, IndexParentChildFieldData globalIfd) {
            this.parentWeight = parentWeight;
            this.childrenFilter = new ApplyAcceptedDocsFilter(childrenFilter);
            this.parentIdxs = collector.parentIdxs;
            this.scores = collector.scores;
            this.globalIfd = globalIfd;
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ParentQuery.this.getBoost(), "not implemented yet...");
        }

        @Override
        public Query getQuery() {
            return ParentQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float sum = this.parentWeight.getValueForNormalization();
            return sum *= ParentQuery.this.getBoost() * ParentQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            DocIdSet childrenDocSet = this.childrenFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(childrenDocSet)) {
                return null;
            }
            SortedDocValues bytesValues = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(ParentQuery.this.parentType);
            if (bytesValues == null) {
                return null;
            }
            return new ChildScorer(this, this.parentIdxs, this.scores, childrenDocSet.iterator(), bytesValues);
        }
    }

    private static class ParentOrdAndScoreCollector
    extends NoopCollector
    implements Releasable {
        private final LongHash parentIdxs;
        private FloatArray scores;
        private final IndexParentChildFieldData globalIfd;
        private final BigArrays bigArrays;
        private final String parentType;
        private Scorer scorer;
        private SortedDocValues values;

        ParentOrdAndScoreCollector(SearchContext searchContext, IndexParentChildFieldData globalIfd, String parentType) {
            this.bigArrays = searchContext.bigArrays();
            this.parentIdxs = new LongHash(512L, this.bigArrays);
            this.scores = this.bigArrays.newFloatArray(512L, false);
            this.globalIfd = globalIfd;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            long globalOrdinal;
            if (this.values != null && (globalOrdinal = (long)this.values.getOrd(doc)) != -1L) {
                long parentIdx = this.parentIdxs.add(globalOrdinal);
                if (parentIdx >= 0L) {
                    this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
                    this.scores.set(parentIdx, this.scorer.score());
                } else assert (false) : "parent id should only match once, since there can only be one parent doc";
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(this.parentType);
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentIdxs, this.scores);
        }

        public long parentCount() {
            return this.parentIdxs.size();
        }
    }
}

