/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Weight;

public class ConstantScorer
extends Scorer {
    private final DocIdSetIterator docIdSetIterator;
    private final float constantScore;

    public static ConstantScorer create(DocIdSetIterator iterator, Weight weight, float constantScore) throws IOException {
        return new ConstantScorer(iterator, weight, constantScore);
    }

    private ConstantScorer(DocIdSetIterator docIdSetIterator, Weight w, float constantScore) {
        super(w);
        this.constantScore = constantScore;
        this.docIdSetIterator = docIdSetIterator;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.docIdSetIterator.nextDoc();
    }

    @Override
    public int docID() {
        return this.docIdSetIterator.docID();
    }

    @Override
    public float score() throws IOException {
        assert (this.docIdSetIterator.docID() != Integer.MAX_VALUE);
        return this.constantScore;
    }

    @Override
    public int freq() throws IOException {
        return 1;
    }

    @Override
    public int advance(int target) throws IOException {
        return this.docIdSetIterator.advance(target);
    }

    @Override
    public long cost() {
        return this.docIdSetIterator.cost();
    }
}

