/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.support;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;

public abstract class XContentStructure {
    private final QueryParseContext parseContext;
    private BytesReference innerBytes;

    public XContentStructure(QueryParseContext queryParseContext) {
        this.parseContext = queryParseContext;
    }

    public XContentStructure freeze() throws IOException {
        this.bytes(XContentFactory.smileBuilder().copyCurrentStructure(this.parseContext.parser()).bytes());
        return this;
    }

    public void bytes(BytesReference innerBytes) {
        this.innerBytes = innerBytes;
    }

    public BytesReference bytes() {
        return this.innerBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query asQuery(String ... types) throws IOException {
        BytesReference br = this.bytes();
        assert (br != null) : "innerBytes must be set with .bytes(bytes) or .freeze() before parsing";
        XContentParser innerParser = XContentHelper.createParser(br);
        String[] origTypes = QueryParseContext.setTypesWithPrevious(types);
        XContentParser old = this.parseContext.parser();
        this.parseContext.parser(innerParser);
        try {
            Query query = this.parseContext.parseInnerQuery();
            return query;
        }
        finally {
            this.parseContext.parser(old);
            QueryParseContext.setTypes(origTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query asFilter(String ... types) throws IOException {
        BytesReference br = this.bytes();
        assert (br != null) : "innerBytes must be set with .bytes(bytes) or .freeze() before parsing";
        XContentParser innerParser = XContentHelper.createParser(br);
        String[] origTypes = QueryParseContext.setTypesWithPrevious(types);
        XContentParser old = this.parseContext.parser();
        this.parseContext.parser(innerParser);
        try {
            Filter innerFilter = this.parseContext.parseInnerFilter();
            XConstantScoreQuery xConstantScoreQuery = new XConstantScoreQuery(innerFilter);
            return xConstantScoreQuery;
        }
        finally {
            this.parseContext.parser(old);
            QueryParseContext.setTypes(origTypes);
        }
    }

    public static class InnerFilter
    extends XContentStructure {
        private Query query = null;
        private boolean queryParsed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InnerFilter(QueryParseContext parseContext1, String ... types) throws IOException {
            super(parseContext1);
            if (types != null) {
                String[] origTypes = QueryParseContext.setTypesWithPrevious(types);
                try {
                    Filter innerFilter = parseContext1.parseInnerFilter();
                    this.query = new XConstantScoreQuery(innerFilter);
                    this.queryParsed = true;
                }
                finally {
                    QueryParseContext.setTypes(origTypes);
                }
            } else {
                BytesReference innerBytes = XContentFactory.smileBuilder().copyCurrentStructure(parseContext1.parser()).bytes();
                super.bytes(innerBytes);
            }
        }

        @Override
        public Query asFilter(String ... types) throws IOException {
            if (!this.queryParsed) {
                this.query = super.asFilter(types);
            }
            return this.query;
        }
    }

    public static class InnerQuery
    extends XContentStructure {
        private Query query = null;
        private boolean queryParsed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InnerQuery(QueryParseContext parseContext1, String ... types) throws IOException {
            super(parseContext1);
            if (types != null) {
                String[] origTypes = QueryParseContext.setTypesWithPrevious(types);
                try {
                    this.query = parseContext1.parseInnerQuery();
                    this.queryParsed = true;
                }
                finally {
                    QueryParseContext.setTypes(origTypes);
                }
            } else {
                BytesReference innerBytes = XContentFactory.smileBuilder().copyCurrentStructure(parseContext1.parser()).bytes();
                super.bytes(innerBytes);
            }
        }

        @Override
        public Query asQuery(String ... types) throws IOException {
            if (!this.queryParsed) {
                this.query = super.asQuery(types);
            }
            return this.query;
        }
    }
}

