/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class RangeQueryParser
implements QueryParser {
    public static final String NAME = "range";

    @Inject
    public RangeQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[range] query malformed, no field to indicate field name");
        }
        String fieldName = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new QueryParsingException(parseContext.index(), "[range] query malformed, after field missing start object");
        }
        Object from = null;
        Object to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        DateTimeZone timeZone = null;
        DateMathParser forcedDateParser = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("from".equals(currentFieldName)) {
                from = parser.objectBytes();
                continue;
            }
            if ("to".equals(currentFieldName)) {
                to = parser.objectBytes();
                continue;
            }
            if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                includeLower = parser.booleanValue();
                continue;
            }
            if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                includeUpper = parser.booleanValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("gt".equals(currentFieldName)) {
                from = parser.objectBytes();
                includeLower = false;
                continue;
            }
            if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                from = parser.objectBytes();
                includeLower = true;
                continue;
            }
            if ("lt".equals(currentFieldName)) {
                to = parser.objectBytes();
                includeUpper = false;
                continue;
            }
            if ("lte".equals(currentFieldName) || "le".equals(currentFieldName)) {
                to = parser.objectBytes();
                includeUpper = true;
                continue;
            }
            if ("time_zone".equals(currentFieldName) || "timeZone".equals(currentFieldName)) {
                timeZone = DateMathParser.parseZone(parser.text());
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if ("format".equals(currentFieldName)) {
                forcedDateParser = new DateMathParser(Joda.forPattern(parser.text()), DateFieldMapper.Defaults.TIME_UNIT);
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[range] query does not support [" + currentFieldName + "]");
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new QueryParsingException(parseContext.index(), "[range] query malformed, does not end with an object");
        }
        Query query = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            FieldMapper mapper = smartNameFieldMappers.mapper();
            if (mapper instanceof DateFieldMapper) {
                if ((from instanceof Number || to instanceof Number) && timeZone != null) {
                    throw new QueryParsingException(parseContext.index(), "[range] time_zone when using ms since epoch format as it's UTC based can not be applied to [" + fieldName + "]");
                }
                query = ((DateFieldMapper)mapper).rangeQuery(from, to, includeLower, includeUpper, timeZone, forcedDateParser, parseContext);
            } else {
                if (timeZone != null) {
                    throw new QueryParsingException(parseContext.index(), "[range] time_zone can not be applied to non date field [" + fieldName + "]");
                }
                query = mapper.rangeQuery(from, to, includeLower, includeUpper, parseContext);
            }
        }
        if (query == null) {
            query = new TermRangeQuery(fieldName, BytesRefs.toBytesRef(from), BytesRefs.toBytesRef(to), includeLower, includeUpper);
        }
        query.setBoost(boost);
        query = QueryParsers.wrapSmartNameQuery(query, smartNameFieldMappers, parseContext);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

