/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

@Deprecated
public class NumericRangeFilterParser
implements FilterParser {
    public static final String NAME = "numeric_range";

    @Inject
    public NumericRangeFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "numericRange"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        String from = null;
        String to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("from".equals(currentFieldName)) {
                        from = parser.textOrNull();
                        continue;
                    }
                    if ("to".equals(currentFieldName)) {
                        to = parser.textOrNull();
                        continue;
                    }
                    if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if ("gt".equals(currentFieldName)) {
                        from = parser.textOrNull();
                        includeLower = false;
                        continue;
                    }
                    if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                        from = parser.textOrNull();
                        includeLower = true;
                        continue;
                    }
                    if ("lt".equals(currentFieldName)) {
                        to = parser.textOrNull();
                        includeUpper = false;
                        continue;
                    }
                    if ("lte".equals(currentFieldName) || "le".equals(currentFieldName)) {
                        to = parser.textOrNull();
                        includeUpper = true;
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[numeric_range] filter does not support [" + currentFieldName + "]");
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[numeric_range] filter does not support [" + currentFieldName + "]");
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers == null || !smartNameFieldMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "failed to find mapping for field [" + fieldName + "]");
        }
        FieldMapper mapper = smartNameFieldMappers.mapper();
        if (!(mapper instanceof NumberFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "Field [" + fieldName + "] is not a numeric type");
        }
        Filter filter = ((NumberFieldMapper)mapper).rangeFilter(parseContext, from, to, includeLower, includeUpper, parseContext);
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

