/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.join.ScoreMode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.InnerHitsQueryParserHelper;
import org.elasticsearch.index.query.support.NestedInnerQueryParseSupport;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.internal.SubSearchContext;

public class NestedQueryParser
implements QueryParser {
    public static final String NAME = "nested";
    private final InnerHitsQueryParserHelper innerHitsQueryParserHelper;

    @Inject
    public NestedQueryParser(InnerHitsQueryParserHelper innerHitsQueryParserHelper) {
        this.innerHitsQueryParserHelper = innerHitsQueryParserHelper;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ToBlockJoinQueryBuilder builder = new ToBlockJoinQueryBuilder(parseContext);
        float boost = 1.0f;
        ScoreMode scoreMode = ScoreMode.Avg;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    builder.query();
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    builder.filter();
                    continue;
                }
                if ("inner_hits".equals(currentFieldName)) {
                    builder.setInnerHits(this.innerHitsQueryParserHelper.parse(parseContext));
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[nested] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("path".equals(currentFieldName)) {
                builder.setPath(parser.text());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("score_mode".equals(currentFieldName) || "scoreMode".equals(currentFieldName)) {
                String sScoreMode = parser.text();
                if ("avg".equals(sScoreMode)) {
                    scoreMode = ScoreMode.Avg;
                    continue;
                }
                if ("max".equals(sScoreMode)) {
                    scoreMode = ScoreMode.Max;
                    continue;
                }
                if ("total".equals(sScoreMode) || "sum".equals(sScoreMode)) {
                    scoreMode = ScoreMode.Total;
                    continue;
                }
                if ("none".equals(sScoreMode)) {
                    scoreMode = ScoreMode.None;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "illegal score_mode for nested query [" + sScoreMode + "]");
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[nested] query does not support [" + currentFieldName + "]");
        }
        builder.setScoreMode(scoreMode);
        ToParentBlockJoinQuery joinQuery = builder.build();
        if (joinQuery != null) {
            joinQuery.setBoost(boost);
            if (queryName != null) {
                parseContext.addNamedQuery(queryName, joinQuery);
            }
        }
        return joinQuery;
    }

    public static class ToBlockJoinQueryBuilder
    extends NestedInnerQueryParseSupport {
        private ScoreMode scoreMode;
        private Tuple<String, SubSearchContext> innerHits;

        public ToBlockJoinQueryBuilder(QueryParseContext parseContext) throws IOException {
            super(parseContext);
        }

        public void setScoreMode(ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
        }

        public void setInnerHits(Tuple<String, SubSearchContext> innerHits) {
            this.innerHits = innerHits;
        }

        @Nullable
        public ToParentBlockJoinQuery build() throws IOException {
            Query innerQuery;
            if (this.queryFound) {
                innerQuery = this.getInnerQuery();
            } else if (this.filterFound) {
                Filter innerFilter = this.getInnerFilter();
                innerQuery = innerFilter != null ? new XConstantScoreQuery(this.getInnerFilter()) : null;
            } else {
                throw new QueryParsingException(this.parseContext.index(), "[nested] requires either 'query' or 'filter' field");
            }
            if (this.innerHits != null) {
                InnerHitsContext.NestedInnerHits nestedInnerHits = new InnerHitsContext.NestedInnerHits(this.innerHits.v2(), innerQuery, null, this.getParentObjectMapper(), this.nestedObjectMapper);
                String name = this.innerHits.v1() != null ? this.innerHits.v1() : this.path;
                this.parseContext.addInnerHits(name, nestedInnerHits);
            }
            if (innerQuery != null) {
                return new ToParentBlockJoinQuery(new XFilteredQuery(innerQuery, this.childFilter), this.parentFilter, this.scoreMode);
            }
            return null;
        }
    }
}

