/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.join.ScoreMode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.NestedQueryParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.InnerHitsQueryParserHelper;

public class NestedFilterParser
implements FilterParser {
    public static final String NAME = "nested";
    private final InnerHitsQueryParserHelper innerHitsQueryParserHelper;

    @Inject
    public NestedFilterParser(InnerHitsQueryParserHelper innerHitsQueryParserHelper) {
        this.innerHitsQueryParserHelper = innerHitsQueryParserHelper;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        NestedQueryParser.ToBlockJoinQueryBuilder builder = new NestedQueryParser.ToBlockJoinQueryBuilder(parseContext);
        float boost = 1.0f;
        boolean join = true;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    builder.query();
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    builder.filter();
                    continue;
                }
                if ("inner_hits".equals(currentFieldName)) {
                    builder.setInnerHits(this.innerHitsQueryParserHelper.parse(parseContext));
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[nested] filter does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("join".equals(currentFieldName)) {
                join = parser.booleanValue();
                continue;
            }
            if ("path".equals(currentFieldName)) {
                builder.setPath(parser.text());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[nested] filter does not support [" + currentFieldName + "]");
        }
        builder.setScoreMode(ScoreMode.None);
        ToParentBlockJoinQuery joinQuery = builder.build();
        if (joinQuery != null) {
            Query innerQuery = builder.queryFound() ? builder.getInnerQuery() : new XConstantScoreQuery(builder.getInnerFilter());
            innerQuery.setBoost(boost);
            Filter nestedFilter = join ? Queries.wrap(joinQuery, parseContext) : Queries.wrap(innerQuery, parseContext);
            if (cache) {
                nestedFilter = parseContext.cacheFilter(nestedFilter, cacheKey);
            }
            if (filterName != null) {
                parseContext.addNamedFilter(filterName, nestedFilter);
            }
            return nestedFilter;
        }
        return null;
    }
}

