/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

@Deprecated
public class MoreLikeThisFieldQueryParser
implements QueryParser {
    public static final String NAME = "mlt_field";

    @Inject
    public MoreLikeThisFieldQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "more_like_this_field", Strings.toCamelCase(NAME), "moreLikeThisField"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        token = parser.nextToken();
        assert (token == XContentParser.Token.START_OBJECT);
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(parseContext.searchSimilarity());
        Analyzer analyzer = null;
        boolean failOnUnsupportedField = true;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (MoreLikeThisQueryParser.Fields.LIKE_TEXT.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setLikeText(parser.text());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.MIN_TERM_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinTermFrequency(parser.intValue());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.MAX_QUERY_TERMS.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxQueryTerms(parser.intValue());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.MIN_DOC_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinDocFreq(parser.intValue());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.MAX_DOC_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxDocFreq(parser.intValue());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.MIN_WORD_LENGTH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinWordLen(parser.intValue());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.MAX_WORD_LENGTH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxWordLen(parser.intValue());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.BOOST_TERMS.match(currentFieldName, parseContext.parseFlags())) {
                    float boostFactor = parser.floatValue();
                    if (boostFactor == 0.0f) continue;
                    mltQuery.setBoostTerms(true);
                    mltQuery.setBoostTermsFactor(boostFactor);
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.MINIMUM_SHOULD_MATCH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinimumShouldMatch(parser.text());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.PERCENT_TERMS_TO_MATCH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinimumShouldMatch(Math.round(parser.floatValue() * 100.0f) + "%");
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    mltQuery.setBoost(parser.floatValue());
                    continue;
                }
                if (MoreLikeThisQueryParser.Fields.FAIL_ON_UNSUPPORTED_FIELD.match(currentFieldName, parseContext.parseFlags())) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[mlt_field] query does not support [" + currentFieldName + "]");
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if (MoreLikeThisQueryParser.Fields.STOP_WORDS.match(currentFieldName, parseContext.parseFlags())) {
                HashSet<String> stopWords = Sets.newHashSet();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    stopWords.add(parser.text());
                }
                mltQuery.setStopWords(stopWords);
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[mlt_field] query does not support [" + currentFieldName + "]");
        }
        if (mltQuery.getLikeText() == null) {
            throw new QueryParsingException(parseContext.index(), "more_like_this_field requires 'like_text' to be specified");
        }
        token = parser.nextToken();
        assert (token == XContentParser.Token.END_OBJECT);
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null) {
            if (smartNameFieldMappers.hasMapper()) {
                fieldName = smartNameFieldMappers.mapper().names().indexName();
            }
            if (analyzer == null) {
                analyzer = smartNameFieldMappers.searchAnalyzer();
            }
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        if (!Analysis.generatesCharacterTokenStream(analyzer, fieldName)) {
            if (failOnUnsupportedField) {
                throw new ElasticsearchIllegalArgumentException("more_like_this_field doesn't support binary/numeric fields: [" + fieldName + "]");
            }
            return null;
        }
        mltQuery.setAnalyzer(analyzer);
        mltQuery.setMoreLikeFields(new String[]{fieldName});
        Query query = QueryParsers.wrapSmartNameQuery(mltQuery, smartNameFieldMappers, parseContext);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

