/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilterCache;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.FilterParserFactory;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParserFactory;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.script.ScriptService;

public class IndexQueryParserService
extends AbstractIndexComponent {
    public static final String DEFAULT_FIELD = "index.query.default_field";
    public static final String QUERY_STRING_LENIENT = "index.query_string.lenient";
    public static final String PARSE_STRICT = "index.query.parse.strict";
    public static final String ALLOW_UNMAPPED = "index.query.parse.allow_unmapped_fields";
    private CloseableThreadLocal<QueryParseContext> cache = new CloseableThreadLocal<QueryParseContext>(){

        @Override
        protected QueryParseContext initialValue() {
            return new QueryParseContext(IndexQueryParserService.this.index, IndexQueryParserService.this);
        }
    };
    final CacheRecycler cacheRecycler;
    final AnalysisService analysisService;
    final ScriptService scriptService;
    final MapperService mapperService;
    final SimilarityService similarityService;
    final IndexCache indexCache;
    final IndexFieldDataService fieldDataService;
    final FixedBitSetFilterCache fixedBitSetFilterCache;
    final IndexEngine indexEngine;
    private final Map<String, QueryParser> queryParsers;
    private final Map<String, FilterParser> filterParsers;
    private String defaultField;
    private boolean queryStringLenient;
    private final boolean strict;
    private final boolean defaultAllowUnmappedFields;

    @Inject
    public IndexQueryParserService(Index index, @IndexSettings Settings indexSettings, IndicesQueriesRegistry indicesQueriesRegistry, CacheRecycler cacheRecycler, ScriptService scriptService, AnalysisService analysisService, MapperService mapperService, IndexCache indexCache, IndexFieldDataService fieldDataService, IndexEngine indexEngine, FixedBitSetFilterCache fixedBitSetFilterCache, @Nullable SimilarityService similarityService, @Nullable Map<String, QueryParserFactory> namedQueryParsers, @Nullable Map<String, FilterParserFactory> namedFilterParsers) {
        super(index, indexSettings);
        this.cacheRecycler = cacheRecycler;
        this.scriptService = scriptService;
        this.analysisService = analysisService;
        this.mapperService = mapperService;
        this.similarityService = similarityService;
        this.indexCache = indexCache;
        this.fieldDataService = fieldDataService;
        this.indexEngine = indexEngine;
        this.fixedBitSetFilterCache = fixedBitSetFilterCache;
        this.defaultField = indexSettings.get(DEFAULT_FIELD, "_all");
        this.queryStringLenient = indexSettings.getAsBoolean(QUERY_STRING_LENIENT, (Boolean)false);
        this.strict = indexSettings.getAsBoolean(PARSE_STRICT, (Boolean)false);
        this.defaultAllowUnmappedFields = indexSettings.getAsBoolean(ALLOW_UNMAPPED, (Boolean)true);
        ArrayList<QueryParser> queryParsers = Lists.newArrayList();
        if (namedQueryParsers != null) {
            Map<String, Settings> queryParserGroups = indexSettings.getGroups("index.queryparser.query");
            for (Map.Entry<String, QueryParserFactory> entry : namedQueryParsers.entrySet()) {
                String queryParserName = entry.getKey();
                QueryParserFactory queryParserFactory = entry.getValue();
                Settings queryParserSettings = queryParserGroups.get(queryParserName);
                if (queryParserSettings == null) {
                    queryParserSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                queryParsers.add(queryParserFactory.create(queryParserName, queryParserSettings));
            }
        }
        HashMap<String, QueryParser> queryParsersMap = Maps.newHashMap();
        queryParsersMap.putAll(indicesQueriesRegistry.queryParsers());
        if (queryParsers != null) {
            for (QueryParser queryParser : queryParsers) {
                this.add(queryParsersMap, queryParser);
            }
        }
        this.queryParsers = ImmutableMap.copyOf(queryParsersMap);
        ArrayList<FilterParser> filterParsers = Lists.newArrayList();
        if (namedFilterParsers != null) {
            Map<String, Settings> filterParserGroups = indexSettings.getGroups("index.queryparser.filter");
            for (Map.Entry<String, FilterParserFactory> entry : namedFilterParsers.entrySet()) {
                String filterParserName = entry.getKey();
                FilterParserFactory filterParserFactory = entry.getValue();
                Settings filterParserSettings = filterParserGroups.get(filterParserName);
                if (filterParserSettings == null) {
                    filterParserSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                filterParsers.add(filterParserFactory.create(filterParserName, filterParserSettings));
            }
        }
        HashMap<String, FilterParser> filterParsersMap = Maps.newHashMap();
        filterParsersMap.putAll(indicesQueriesRegistry.filterParsers());
        if (filterParsers != null) {
            for (FilterParser filterParser : filterParsers) {
                this.add(filterParsersMap, filterParser);
            }
        }
        this.filterParsers = ImmutableMap.copyOf(filterParsersMap);
    }

    public void close() {
        this.cache.close();
    }

    public String defaultField() {
        return this.defaultField;
    }

    public boolean queryStringLenient() {
        return this.queryStringLenient;
    }

    public QueryParser queryParser(String name) {
        return this.queryParsers.get(name);
    }

    public FilterParser filterParser(String name) {
        return this.filterParsers.get(name);
    }

    public ParsedQuery parse(QueryBuilder queryBuilder) throws ElasticsearchException {
        try (Releasable parser = null;){
            BytesReference bytes = queryBuilder.buildAsBytes();
            parser = XContentFactory.xContent(bytes).createParser(bytes);
            ParsedQuery parsedQuery = this.parse(this.cache.get(), (XContentParser)parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(byte[] source) throws ElasticsearchException {
        return this.parse(source, 0, source.length);
    }

    public ParsedQuery parse(byte[] source, int offset, int length) throws ElasticsearchException {
        try (Releasable parser = null;){
            parser = XContentFactory.xContent(source, offset, length).createParser(source, offset, length);
            ParsedQuery parsedQuery = this.parse(this.cache.get(), (XContentParser)parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(BytesReference source) throws ElasticsearchException {
        return this.parse(this.cache.get(), source);
    }

    public ParsedQuery parse(QueryParseContext context, BytesReference source) throws ElasticsearchException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent(source).createParser(source);
            ParsedQuery parsedQuery = this.innerParse(context, parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(String source) throws QueryParsingException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent(source).createParser(source);
            ParsedQuery parsedQuery = this.innerParse(this.cache.get(), parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(XContentParser parser) {
        return this.parse(this.cache.get(), parser);
    }

    public ParsedQuery parse(QueryParseContext context, XContentParser parser) {
        try {
            return this.innerParse(context, parser);
        }
        catch (IOException e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ParsedFilter parseInnerFilter(XContentParser parser) throws IOException {
        QueryParseContext context = this.cache.get();
        context.reset(parser);
        try {
            Filter filter = context.parseInnerFilter();
            if (filter == null) {
                ParsedFilter parsedFilter = null;
                return parsedFilter;
            }
            ParsedFilter parsedFilter = new ParsedFilter(filter, context.copyNamedFilters());
            return parsedFilter;
        }
        finally {
            context.reset(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Query parseInnerQuery(XContentParser parser) throws IOException {
        QueryParseContext context = this.cache.get();
        context.reset(parser);
        try {
            Query query = context.parseInnerQuery();
            return query;
        }
        finally {
            context.reset(null);
        }
    }

    @Nullable
    public Query parseInnerQuery(QueryParseContext parseContext) throws IOException {
        Query query;
        if (this.strict) {
            parseContext.parseFlags(EnumSet.of(ParseField.Flag.STRICT));
        }
        if ((query = parseContext.parseInnerQuery()) == null) {
            query = Queries.newMatchNoDocsQuery();
        }
        return query;
    }

    public QueryParseContext getParseContext() {
        return this.cache.get();
    }

    public boolean defaultAllowUnmappedFields() {
        return this.defaultAllowUnmappedFields;
    }

    public Version getIndexCreatedVersion() {
        return Version.indexCreated(this.indexSettings);
    }

    public ParsedQuery parseQuery(BytesReference source) {
        try {
            ParsedQuery parsedQuery = null;
            XContentParser parser = XContentHelper.createParser(source);
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    if ("query".equals(fieldName)) {
                        parsedQuery = this.parse(parser);
                    } else if ("query_binary".equals(fieldName) || "queryBinary".equals(fieldName)) {
                        byte[] querySource = parser.binaryValue();
                        XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);
                        parsedQuery = this.parse(qSourceParser);
                    } else {
                        throw new QueryParsingException(this.index(), "request does not support [" + fieldName + "]");
                    }
                }
                token = parser.nextToken();
            }
            if (parsedQuery != null) {
                return parsedQuery;
            }
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
        throw new QueryParsingException(this.index(), "Required query is missing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsedQuery innerParse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        parseContext.reset(parser);
        try {
            Query query;
            if (this.strict) {
                parseContext.parseFlags(EnumSet.of(ParseField.Flag.STRICT));
            }
            if ((query = parseContext.parseInnerQuery()) == null) {
                query = Queries.newMatchNoDocsQuery();
            }
            ParsedQuery parsedQuery = new ParsedQuery(query, parseContext.copyNamedFilters());
            return parsedQuery;
        }
        finally {
            parseContext.reset(null);
        }
    }

    private void add(Map<String, FilterParser> map, FilterParser filterParser) {
        for (String name : filterParser.names()) {
            map.put(name.intern(), filterParser);
        }
    }

    private void add(Map<String, QueryParser> map, QueryParser queryParser) {
        for (String name : queryParser.names()) {
            map.put(name.intern(), queryParser);
        }
    }

    public static final class Defaults {
        public static final String QUERY_PREFIX = "index.queryparser.query";
        public static final String FILTER_PREFIX = "index.queryparser.filter";
    }
}

