/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.sandbox.queries.FuzzyLikeThisQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class FuzzyLikeThisQueryParser
implements QueryParser {
    public static final String NAME = "flt";
    private static final ParseField FUZZINESS = Fuzziness.FIELD.withDeprecation("min_similarity");

    @Inject
    public FuzzyLikeThisQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "fuzzy_like_this", "fuzzyLikeThis"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        int maxNumTerms = 25;
        float boost = 1.0f;
        AbstractList fields = null;
        String likeText = null;
        Fuzziness fuzziness = Fuzziness.TWO;
        int prefixLength = 0;
        boolean ignoreTF = false;
        Analyzer analyzer = null;
        boolean failOnUnsupportedField = true;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("like_text".equals(currentFieldName) || "likeText".equals(currentFieldName)) {
                    likeText = parser.text();
                    continue;
                }
                if ("max_query_terms".equals(currentFieldName) || "maxQueryTerms".equals(currentFieldName)) {
                    maxNumTerms = parser.intValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("ignore_tf".equals(currentFieldName) || "ignoreTF".equals(currentFieldName)) {
                    ignoreTF = parser.booleanValue();
                    continue;
                }
                if (FUZZINESS.match(currentFieldName, parseContext.parseFlags())) {
                    fuzziness = Fuzziness.parse(parser);
                    continue;
                }
                if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                    prefixLength = parser.intValue();
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                if ("fail_on_unsupported_field".equals(currentFieldName) || "failOnUnsupportedField".equals(currentFieldName)) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[flt] query does not support [" + currentFieldName + "]");
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if ("fields".equals(currentFieldName)) {
                fields = Lists.newLinkedList();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    fields.add(parseContext.indexName(parser.text()));
                }
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[flt] query does not support [" + currentFieldName + "]");
        }
        if (likeText == null) {
            throw new QueryParsingException(parseContext.index(), "fuzzy_like_this requires 'like_text' to be specified");
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        FuzzyLikeThisQuery query = new FuzzyLikeThisQuery(maxNumTerms, analyzer);
        if (fields == null) {
            fields = Lists.newArrayList(parseContext.defaultField());
        } else if (fields.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "fuzzy_like_this requires 'fields' to be non-empty");
        }
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if (Analysis.generatesCharacterTokenStream(analyzer, fieldName)) continue;
            if (failOnUnsupportedField) {
                throw new ElasticsearchIllegalArgumentException("more_like_this doesn't support binary/numeric fields: [" + fieldName + "]");
            }
            it.remove();
        }
        if (fields.isEmpty()) {
            return null;
        }
        float minSimilarity = fuzziness.asFloat();
        if (minSimilarity >= 1.0f && minSimilarity != (float)((int)minSimilarity)) {
            throw new ElasticsearchIllegalArgumentException("fractional edit distances are not allowed");
        }
        if (minSimilarity < 0.0f) {
            throw new ElasticsearchIllegalArgumentException("minimumSimilarity cannot be less than 0");
        }
        for (String field : fields) {
            query.addTerms(likeText, field, minSimilarity, prefixLength);
        }
        query.setBoost(boost);
        query.setIgnoreTF(ignoreTF);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

