/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class FieldMaskingSpanQueryParser
implements QueryParser {
    public static final String NAME = "field_masking_span";

    @Inject
    public FieldMaskingSpanQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        SpanQuery inner = null;
        String field = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    Query query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext.index(), "[field_masking_span] query] must be of type span query");
                    }
                    inner = (SpanQuery)query;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[field_masking_span] query does not support [" + currentFieldName + "]");
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("field".equals(currentFieldName)) {
                field = parser.text();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[field_masking_span] query does not support [" + currentFieldName + "]");
        }
        if (inner == null) {
            throw new QueryParsingException(parseContext.index(), "field_masking_span must have [query] span query clause");
        }
        if (field == null) {
            throw new QueryParsingException(parseContext.index(), "field_masking_span must have [field] set for it");
        }
        FieldMapper mapper = parseContext.fieldMapper(field);
        if (mapper != null) {
            field = mapper.names().indexName();
        }
        FieldMaskingSpanQuery query = new FieldMaskingSpanQuery(inner, field);
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

