/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class BoolQueryParser
implements QueryParser {
    public static final String NAME = "bool";

    @Inject
    public BoolQueryParser(Settings settings) {
        BooleanQuery.setMaxClauseCount(settings.getAsInt("index.query.bool.max_clause_count", settings.getAsInt("indices.query.bool.max_clause_count", (Integer)BooleanQuery.getMaxClauseCount())));
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean disableCoord = false;
        float boost = 1.0f;
        String minimumShouldMatch = null;
        ArrayList<BooleanClause> clauses = Lists.newArrayList();
        boolean adjustPureNegative = true;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            Query query2;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("must".equals(currentFieldName)) {
                    query2 = parseContext.parseInnerQuery();
                    if (query2 == null) continue;
                    clauses.add(new BooleanClause(query2, BooleanClause.Occur.MUST));
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    query2 = parseContext.parseInnerQuery();
                    if (query2 == null) continue;
                    clauses.add(new BooleanClause(query2, BooleanClause.Occur.MUST_NOT));
                    continue;
                }
                if ("should".equals(currentFieldName)) {
                    query2 = parseContext.parseInnerQuery();
                    if (query2 == null) continue;
                    clauses.add(new BooleanClause(query2, BooleanClause.Occur.SHOULD));
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[bool] query does not support [" + currentFieldName + "]");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("must".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        query2 = parseContext.parseInnerQuery();
                        if (query2 == null) continue;
                        clauses.add(new BooleanClause(query2, BooleanClause.Occur.MUST));
                    }
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        query2 = parseContext.parseInnerQuery();
                        if (query2 == null) continue;
                        clauses.add(new BooleanClause(query2, BooleanClause.Occur.MUST_NOT));
                    }
                    continue;
                }
                if ("should".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        query2 = parseContext.parseInnerQuery();
                        if (query2 == null) continue;
                        clauses.add(new BooleanClause(query2, BooleanClause.Occur.SHOULD));
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "bool query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                disableCoord = parser.booleanValue();
                continue;
            }
            if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("minimum_number_should_match".equals(currentFieldName) || "minimumNumberShouldMatch".equals(currentFieldName)) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if ("adjust_pure_negative".equals(currentFieldName) || "adjustPureNegative".equals(currentFieldName)) {
                adjustPureNegative = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[bool] query does not support [" + currentFieldName + "]");
        }
        if (clauses.isEmpty()) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery booleanQuery = new BooleanQuery(disableCoord);
        for (BooleanClause clause : clauses) {
            booleanQuery.add(clause);
        }
        booleanQuery.setBoost(boost);
        Queries.applyMinimumShouldMatch(booleanQuery, minimumShouldMatch);
        Query query3 = query = adjustPureNegative ? Queries.fixNegativeQueryIfNeeded(booleanQuery) : booleanQuery;
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

