/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fieldvisitor.JustSourceFieldsVisitor;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;

final class QueriesLoaderCollector
extends Collector {
    private final Map<BytesRef, Query> queries = Maps.newHashMap();
    private final JustSourceFieldsVisitor fieldsVisitor = new JustSourceFieldsVisitor();
    private final PercolatorQueriesRegistry percolator;
    private final IndexFieldData<?> idFieldData;
    private final ESLogger logger;
    private SortedBinaryDocValues idValues;
    private AtomicReader reader;

    QueriesLoaderCollector(PercolatorQueriesRegistry percolator, ESLogger logger, MapperService mapperService, IndexFieldDataService indexFieldDataService) {
        this.percolator = percolator;
        this.logger = logger;
        FieldMapper idMapper = mapperService.smartNameFieldMapper("_id");
        this.idFieldData = indexFieldDataService.getForField(idMapper);
    }

    public Map<BytesRef, Query> queries() {
        return this.queries;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.idValues.setDocument(doc);
        if (this.idValues.count() > 0) {
            assert (this.idValues.count() == 1);
            BytesRef id = this.idValues.valueAt(0);
            this.fieldsVisitor.reset();
            this.reader.document(doc, this.fieldsVisitor);
            try {
                Query parseQuery = this.percolator.parsePercolatorDocument(null, this.fieldsVisitor.source());
                if (parseQuery != null) {
                    this.queries.put(BytesRef.deepCopyOf(id), parseQuery);
                } else {
                    this.logger.warn("failed to add query [{}] - parser returned null", id);
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to add query [{}]", e, id.utf8ToString());
            }
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.reader = context.reader();
        this.idValues = this.idFieldData.load(context).getBytesValues();
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return true;
    }
}

