/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.MergePolicy;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.MergeScheduler;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TrackingConcurrentMergeScheduler;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

@Deprecated
public class SerialMergeSchedulerProvider
extends MergeSchedulerProvider {
    public static final int DEFAULT_MAX_MERGE_AT_ONCE = 5;
    private Set<CustomSerialMergeScheduler> schedulers = new CopyOnWriteArraySet<CustomSerialMergeScheduler>();

    @Inject
    public SerialMergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool) {
        super(shardId, indexSettings, threadPool);
        Integer value = this.componentSettings.getAsInt("max_merge_at_once", null);
        if (value != null) {
            this.logger.warn("ignoring index.merge.scheduler.max_merge_at_once [{}], because we are using ConcurrentMergeScheduler(2, 1)", value);
        }
        this.logger.trace("using [concurrent] merge scheduler, max_thread_count=1, max_merge_count=2", new Object[0]);
    }

    @Override
    public int getMaxMerges() {
        return 1;
    }

    @Override
    public MergeScheduler buildMergeScheduler() {
        CustomSerialMergeScheduler scheduler = new CustomSerialMergeScheduler(this.logger, this.shardId, this);
        scheduler.setMaxMergesAndThreads(2, 1);
        this.schedulers.add(scheduler);
        return scheduler;
    }

    @Override
    public MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        for (CustomSerialMergeScheduler scheduler : this.schedulers) {
            mergeStats.add(scheduler.totalMerges(), scheduler.totalMergeTime(), scheduler.totalMergeNumDocs(), scheduler.totalMergeSizeInBytes(), scheduler.currentMerges(), scheduler.currentMergesNumDocs(), scheduler.currentMergesSizeInBytes());
        }
        return mergeStats;
    }

    @Override
    public Set<OnGoingMerge> onGoingMerges() {
        Iterator<CustomSerialMergeScheduler> i$ = this.schedulers.iterator();
        if (i$.hasNext()) {
            CustomSerialMergeScheduler scheduler = i$.next();
            return scheduler.onGoingMerges();
        }
        return ImmutableSet.of();
    }

    @Override
    public void close() {
    }

    public static class CustomSerialMergeScheduler
    extends TrackingConcurrentMergeScheduler {
        private final ShardId shardId;
        private final SerialMergeSchedulerProvider provider;

        private CustomSerialMergeScheduler(ESLogger logger, ShardId shardId, SerialMergeSchedulerProvider provider) {
            super(logger);
            this.shardId = shardId;
            this.provider = provider;
        }

        @Override
        protected ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
            ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(writer, merge);
            thread.setName(EsExecutors.threadName(this.provider.indexSettings(), "[" + this.shardId.index().name() + "][" + this.shardId.id() + "]: " + thread.getName()));
            return thread;
        }

        @Override
        protected void handleMergeException(Throwable exc) {
            this.logger.warn("failed to merge", exc, new Object[0]);
            this.provider.failedMerge(new MergePolicy.MergeException(exc, this.dir));
            super.handleMergeException(exc);
        }

        @Override
        public void close() {
            super.close();
            this.provider.schedulers.remove(this);
        }

        @Override
        protected void beforeMerge(OnGoingMerge merge) {
            super.beforeMerge(merge);
            this.provider.beforeMerge(merge);
        }

        @Override
        protected void afterMerge(OnGoingMerge merge) {
            super.afterMerge(merge);
            this.provider.afterMerge(merge);
        }
    }
}

