/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TieredMergePolicy;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.AbstractMergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.Store;

public class TieredMergePolicyProvider
extends AbstractMergePolicyProvider<TieredMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    private final ApplySettings applySettings = new ApplySettings();
    private final TieredMergePolicy mergePolicy = new TieredMergePolicy();
    public static final double DEFAULT_EXPUNGE_DELETES_ALLOWED = 10.0;
    public static final ByteSizeValue DEFAULT_FLOOR_SEGMENT = new ByteSizeValue(2L, ByteSizeUnit.MB);
    public static final int DEFAULT_MAX_MERGE_AT_ONCE = 10;
    public static final int DEFAULT_MAX_MERGE_AT_ONCE_EXPLICIT = 30;
    public static final ByteSizeValue DEFAULT_MAX_MERGED_SEGMENT = new ByteSizeValue(5L, ByteSizeUnit.GB);
    public static final double DEFAULT_SEGMENTS_PER_TIER = 10.0;
    public static final double DEFAULT_RECLAIM_DELETES_WEIGHT = 2.0;
    public static final String INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED = "index.merge.policy.expunge_deletes_allowed";
    public static final String INDEX_MERGE_POLICY_FLOOR_SEGMENT = "index.merge.policy.floor_segment";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE = "index.merge.policy.max_merge_at_once";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT = "index.merge.policy.max_merge_at_once_explicit";
    public static final String INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT = "index.merge.policy.max_merged_segment";
    public static final String INDEX_MERGE_POLICY_SEGMENTS_PER_TIER = "index.merge.policy.segments_per_tier";
    public static final String INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT = "index.merge.policy.reclaim_deletes_weight";

    @Inject
    public TieredMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store);
        this.indexSettingsService = indexSettingsService;
        double forceMergeDeletesPctAllowed = this.componentSettings.getAsDouble("expunge_deletes_allowed", (Double)10.0);
        ByteSizeValue floorSegment = this.componentSettings.getAsBytesSize("floor_segment", DEFAULT_FLOOR_SEGMENT);
        int maxMergeAtOnce = this.componentSettings.getAsInt("max_merge_at_once", (Integer)10);
        int maxMergeAtOnceExplicit = this.componentSettings.getAsInt("max_merge_at_once_explicit", (Integer)30);
        ByteSizeValue maxMergedSegment = this.componentSettings.getAsBytesSize("max_merged_segment", DEFAULT_MAX_MERGED_SEGMENT);
        double segmentsPerTier = this.componentSettings.getAsDouble("segments_per_tier", (Double)10.0);
        double reclaimDeletesWeight = this.componentSettings.getAsDouble("reclaim_deletes_weight", (Double)2.0);
        maxMergeAtOnce = this.adjustMaxMergeAtOnceIfNeeded(maxMergeAtOnce, segmentsPerTier);
        this.mergePolicy.setNoCFSRatio(this.noCFSRatio);
        this.mergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
        this.mergePolicy.setFloorSegmentMB(floorSegment.mbFrac());
        this.mergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
        this.mergePolicy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
        this.mergePolicy.setMaxMergedSegmentMB(maxMergedSegment.mbFrac());
        this.mergePolicy.setSegmentsPerTier(segmentsPerTier);
        this.mergePolicy.setReclaimDeletesWeight(reclaimDeletesWeight);
        this.logger.debug("using [tiered] merge mergePolicy with expunge_deletes_allowed[{}], floor_segment[{}], max_merge_at_once[{}], max_merge_at_once_explicit[{}], max_merged_segment[{}], segments_per_tier[{}], reclaim_deletes_weight[{}]", forceMergeDeletesPctAllowed, floorSegment, maxMergeAtOnce, maxMergeAtOnceExplicit, maxMergedSegment, segmentsPerTier, reclaimDeletesWeight);
        indexSettingsService.addListener(this.applySettings);
    }

    private int adjustMaxMergeAtOnceIfNeeded(int maxMergeAtOnce, double segmentsPerTier) {
        if (!(segmentsPerTier >= (double)maxMergeAtOnce)) {
            int newMaxMergeAtOnce = (int)segmentsPerTier;
            if (newMaxMergeAtOnce <= 1) {
                newMaxMergeAtOnce = 2;
            }
            this.logger.debug("[tiered] merge mergePolicy changing max_merge_at_once from [{}] to [{}] because segments_per_tier [{}] has to be higher or equal to it", maxMergeAtOnce, newMaxMergeAtOnce, segmentsPerTier);
            maxMergeAtOnce = newMaxMergeAtOnce;
        }
        return maxMergeAtOnce;
    }

    @Override
    public TieredMergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            double noCFSRatio;
            double oldReclaimDeletesWeight;
            double reclaimDeletesWeight;
            int oldMaxMergeAtOnceExplicit;
            int maxMergeAtOnceExplicit;
            int oldMaxMergeAtOnce;
            int maxMergeAtOnce;
            double oldSegmentsPerTier;
            double segmentsPerTier;
            double oldExpungeDeletesPctAllowed = TieredMergePolicyProvider.this.mergePolicy.getForceMergeDeletesPctAllowed();
            double expungeDeletesPctAllowed = settings.getAsDouble(TieredMergePolicyProvider.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED, (Double)oldExpungeDeletesPctAllowed);
            if (expungeDeletesPctAllowed != oldExpungeDeletesPctAllowed) {
                TieredMergePolicyProvider.this.logger.info("updating [expunge_deletes_allowed] from [{}] to [{}]", oldExpungeDeletesPctAllowed, expungeDeletesPctAllowed);
                TieredMergePolicyProvider.this.mergePolicy.setForceMergeDeletesPctAllowed(expungeDeletesPctAllowed);
            }
            double oldFloorSegmentMB = TieredMergePolicyProvider.this.mergePolicy.getFloorSegmentMB();
            ByteSizeValue floorSegment = settings.getAsBytesSize(TieredMergePolicyProvider.INDEX_MERGE_POLICY_FLOOR_SEGMENT, null);
            if (floorSegment != null && floorSegment.mbFrac() != oldFloorSegmentMB) {
                TieredMergePolicyProvider.this.logger.info("updating [floor_segment] from [{}mb] to [{}]", oldFloorSegmentMB, floorSegment);
                TieredMergePolicyProvider.this.mergePolicy.setFloorSegmentMB(floorSegment.mbFrac());
            }
            if ((segmentsPerTier = settings.getAsDouble(TieredMergePolicyProvider.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER, (Double)(oldSegmentsPerTier = TieredMergePolicyProvider.this.mergePolicy.getSegmentsPerTier())).doubleValue()) != oldSegmentsPerTier) {
                TieredMergePolicyProvider.this.logger.info("updating [segments_per_tier] from [{}] to [{}]", oldSegmentsPerTier, segmentsPerTier);
                TieredMergePolicyProvider.this.mergePolicy.setSegmentsPerTier(segmentsPerTier);
            }
            if ((maxMergeAtOnce = settings.getAsInt(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE, (Integer)(oldMaxMergeAtOnce = TieredMergePolicyProvider.this.mergePolicy.getMaxMergeAtOnce())).intValue()) != oldMaxMergeAtOnce) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merge_at_once] from [{}] to [{}]", oldMaxMergeAtOnce, maxMergeAtOnce);
                maxMergeAtOnce = TieredMergePolicyProvider.this.adjustMaxMergeAtOnceIfNeeded(maxMergeAtOnce, segmentsPerTier);
                TieredMergePolicyProvider.this.mergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
            }
            if ((maxMergeAtOnceExplicit = settings.getAsInt(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT, (Integer)(oldMaxMergeAtOnceExplicit = TieredMergePolicyProvider.this.mergePolicy.getMaxMergeAtOnceExplicit())).intValue()) != oldMaxMergeAtOnceExplicit) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merge_at_once_explicit] from [{}] to [{}]", oldMaxMergeAtOnceExplicit, maxMergeAtOnceExplicit);
                TieredMergePolicyProvider.this.mergePolicy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
            }
            double oldMaxMergedSegmentMB = TieredMergePolicyProvider.this.mergePolicy.getMaxMergedSegmentMB();
            ByteSizeValue maxMergedSegment = settings.getAsBytesSize(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT, null);
            if (maxMergedSegment != null && maxMergedSegment.mbFrac() != oldMaxMergedSegmentMB) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merged_segment] from [{}mb] to [{}]", oldMaxMergedSegmentMB, maxMergedSegment);
                TieredMergePolicyProvider.this.mergePolicy.setMaxMergedSegmentMB(maxMergedSegment.mbFrac());
            }
            if ((reclaimDeletesWeight = settings.getAsDouble(TieredMergePolicyProvider.INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT, (Double)(oldReclaimDeletesWeight = TieredMergePolicyProvider.this.mergePolicy.getReclaimDeletesWeight())).doubleValue()) != oldReclaimDeletesWeight) {
                TieredMergePolicyProvider.this.logger.info("updating [reclaim_deletes_weight] from [{}] to [{}]", oldReclaimDeletesWeight, reclaimDeletesWeight);
                TieredMergePolicyProvider.this.mergePolicy.setReclaimDeletesWeight(reclaimDeletesWeight);
            }
            if ((noCFSRatio = AbstractMergePolicyProvider.parseNoCFSRatio(settings.get("index.compound_format", Double.toString(TieredMergePolicyProvider.this.noCFSRatio)))) != TieredMergePolicyProvider.this.noCFSRatio) {
                TieredMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", AbstractMergePolicyProvider.formatNoCFSRatio(TieredMergePolicyProvider.this.noCFSRatio), AbstractMergePolicyProvider.formatNoCFSRatio(noCFSRatio));
                TieredMergePolicyProvider.this.mergePolicy.setNoCFSRatio(noCFSRatio);
                TieredMergePolicyProvider.this.noCFSRatio = noCFSRatio;
            }
        }
    }
}

