/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.BinaryDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class UidFieldMapper
extends AbstractFieldMapper<Uid>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_uid";
    public static final String CONTENT_TYPE = "_uid";

    public UidFieldMapper() {
        this("_uid");
    }

    protected UidFieldMapper(String name) {
        this(name, name, null, null, null, null, ImmutableSettings.EMPTY);
    }

    protected UidFieldMapper(String name, String indexName, Boolean docValues, PostingsFormatProvider postingsFormat, DocValuesFormatProvider docValuesFormat, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), 1.0f, new FieldType(Defaults.FIELD_TYPE), docValues, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsFormat, docValuesFormat, null, null, fieldDataSettings, indexSettings);
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    protected String defaultPostingFormat() {
        return "default";
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        if (context.sourceToParse().id() != null) {
            context.id(context.sourceToParse().id());
            super.parse(context);
        }
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.id() == null && !context.sourceToParse().flyweight()) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
        if (context.sourceToParse().id() == null) {
            super.parse(context);
            if (context.docs().size() > 1) {
                IndexableField uidField = context.rootDoc().getField("_uid");
                assert (uidField != null);
                for (int i = 1; i < context.docs().size(); ++i) {
                    ParseContext.Document doc = context.docs().get(i);
                    doc.add(new Field("_uid", uidField.stringValue(), Defaults.NESTED_FIELD_TYPE));
                }
            }
        }
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        Field uid = new Field("_uid", Uid.createUid(context.stringBuilder(), context.type(), context.id()), Defaults.FIELD_TYPE);
        context.uid(uid);
        fields.add(uid);
        if (this.hasDocValues()) {
            fields.add(new BinaryDocValuesField("_uid", new BytesRef(uid.stringValue())));
        }
    }

    @Override
    public Uid value(Object value) {
        if (value == null) {
            return null;
        }
        return Uid.createUid(value.toString());
    }

    public Term term(String type, String id) {
        return this.term(Uid.createUid(type, id));
    }

    public Term term(String uid) {
        return this.names().createIndexNameTerm(uid);
    }

    @Override
    protected String contentType() {
        return "_uid";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String format;
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!(includeDefaults || this.customFieldDataSettings != null || this.postingsFormat != null && !this.postingsFormat.name().equals(this.defaultPostingFormat()) || this.docValuesFormat != null && !this.docValuesFormat.name().equals(this.defaultDocValuesFormat()))) {
            return builder;
        }
        builder.startObject("_uid");
        if (this.postingsFormat != null) {
            if (includeDefaults || !this.postingsFormat.name().equals(this.defaultPostingFormat())) {
                builder.field("postings_format", this.postingsFormat.name());
            }
        } else if (includeDefaults) {
            format = this.defaultPostingFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("postings_format", format);
        }
        if (this.docValuesFormat != null) {
            if (includeDefaults || !this.docValuesFormat.name().equals(this.defaultDocValuesFormat())) {
                builder.field("doc_values_format", this.docValuesFormat.name());
            }
        } else if (includeDefaults) {
            format = this.defaultDocValuesFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("doc_values_format", format);
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        AbstractFieldMapper fieldMergeWith = (AbstractFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate() && fieldMergeWith.postingsFormatProvider() != null) {
            this.postingsFormat = fieldMergeWith.postingsFormatProvider();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.uid();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, UidFieldMapper> {
        public Builder() {
            super("_uid", Defaults.FIELD_TYPE);
            this.indexName = "_uid";
        }

        @Override
        public UidFieldMapper build(Mapper.BuilderContext context) {
            return new UidFieldMapper(this.name, this.indexName, this.docValues, this.postingsProvider, this.docValuesProvider, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_uid";
        public static final String INDEX_NAME = "_uid";
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final FieldType NESTED_FIELD_TYPE;

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE = new FieldType(FIELD_TYPE);
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

