/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;

public class FieldNamesFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_field_names";
    public static final String CONTENT_TYPE = "_field_names";
    private final FieldType defaultFieldType = Defaults.FIELD_TYPE;
    private EnabledAttributeMapper enabledState;
    private final boolean pre13Index;

    public FieldNamesFieldMapper(Settings indexSettings) {
        this("_field_names", "_field_names", 1.0f, new FieldType(Defaults.FIELD_TYPE), null, null, Defaults.ENABLED_STATE, null, indexSettings);
    }

    public FieldNamesFieldMapper(String name, String indexName, float boost, FieldType fieldType, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, EnabledAttributeMapper enabledState, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), boost, fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsProvider, docValuesProvider, null, null, fieldDataSettings, indexSettings);
        this.pre13Index = Version.indexCreated(indexSettings).before(Version.V_1_3_0);
        this.enabledState = enabledState;
    }

    public boolean enabled() {
        return !this.pre13Index && this.enabledState.enabled;
    }

    @Override
    public FieldType defaultFieldType() {
        return this.defaultFieldType;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public String value(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    static Iterable<String> extractFieldNames(final String fullPath) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new UnmodifiableIterator<String>(){
                    int endIndex = this.nextEndIndex(0);

                    private int nextEndIndex(int index) {
                        while (index < fullPath.length() && fullPath.charAt(index) != '.') {
                            ++index;
                        }
                        return index;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.endIndex <= fullPath.length();
                    }

                    @Override
                    public String next() {
                        String result = fullPath.substring(0, this.endIndex);
                        this.endIndex = this.nextEndIndex(this.endIndex + 1);
                        return result;
                    }
                };
            }
        };
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.enabledState.enabled) {
            return;
        }
        for (ParseContext.Document document : context.docs()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (IndexableField field : document.getFields()) {
                paths.add(field.name());
            }
            for (String path : paths) {
                for (String fieldName : FieldNamesFieldMapper.extractFieldNames(path)) {
                    if (this.fieldType.indexed() || this.fieldType.stored()) {
                        document.add(new Field(this.names().indexName(), fieldName, this.fieldType));
                    }
                    if (!this.hasDocValues()) continue;
                    document.add(new SortedSetDocValuesField(this.names().indexName(), new BytesRef(fieldName)));
                }
            }
        }
    }

    @Override
    protected String contentType() {
        return "_field_names";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.pre13Index) {
            return builder;
        }
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType().equals(Defaults.FIELD_TYPE) && this.enabledState == Defaults.ENABLED_STATE) {
            return builder;
        }
        builder.startObject("_field_names");
        if (includeDefaults || this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (includeDefaults || !this.fieldType().equals(Defaults.FIELD_TYPE)) {
            super.doXContentBody(builder, includeDefaults, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        FieldNamesFieldMapper fieldNamesMapperMergeWith = (FieldNamesFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate() && fieldNamesMapperMergeWith.enabledState != this.enabledState && !fieldNamesMapperMergeWith.enabledState.unset()) {
            this.enabledState = fieldNamesMapperMergeWith.enabledState;
        }
    }

    @Override
    public boolean isGenerated() {
        return true;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().before(Version.V_1_3_0)) {
                throw new ElasticsearchIllegalArgumentException("type=_field_names is not supported on indices created before version 1.3.0. Is your cluster running multiple datanode versions?");
            }
            Builder builder = MapperBuilders.fieldNames();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, FieldNamesFieldMapper> {
        private EnabledAttributeMapper enabledState = Defaults.ENABLED_STATE;

        public Builder() {
            super("_field_names", new FieldType(Defaults.FIELD_TYPE));
            this.indexName = "_field_names";
        }

        @Override
        public Builder index(boolean index) {
            this.enabled(index);
            return (Builder)super.index(index);
        }

        public Builder enabled(boolean enabled) {
            this.enabledState = enabled ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
            return this;
        }

        @Override
        public FieldNamesFieldMapper build(Mapper.BuilderContext context) {
            return new FieldNamesFieldMapper(this.name, this.indexName, this.boost, this.fieldType, this.postingsProvider, this.docValuesProvider, this.enabledState, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_field_names";
        public static final EnabledAttributeMapper ENABLED_STATE = EnabledAttributeMapper.UNSET_ENABLED;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
        }
    }
}

