/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.Field;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParseContext;

public class ParsedDocument {
    private final Field uid;
    private final Field version;
    private final String id;
    private final String type;
    private final String routing;
    private final long timestamp;
    private final long ttl;
    private final List<ParseContext.Document> documents;
    private final Analyzer analyzer;
    private BytesReference source;
    private boolean mappingsModified;
    private String parent;

    public ParsedDocument(Field uid, Field version, String id, String type, String routing, long timestamp, long ttl, List<ParseContext.Document> documents, Analyzer analyzer, BytesReference source, boolean mappingsModified) {
        this.uid = uid;
        this.version = version;
        this.id = id;
        this.type = type;
        this.routing = routing;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.documents = documents;
        this.source = source;
        this.analyzer = analyzer;
        this.mappingsModified = mappingsModified;
    }

    public Field uid() {
        return this.uid;
    }

    public Field version() {
        return this.version;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String routing() {
        return this.routing;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long ttl() {
        return this.ttl;
    }

    public ParseContext.Document rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<ParseContext.Document> docs() {
        return this.documents;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public BytesReference source() {
        return this.source;
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }

    public ParsedDocument parent(String parent) {
        this.parent = parent;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public boolean mappingsModified() {
        return this.mappingsModified;
    }

    public void setMappingsModified() {
        this.mappingsModified = true;
    }

    public ParsedDocument setMappingsModified(Tuple<DocumentMapper, Boolean> docMapper) {
        if (docMapper.v2().booleanValue()) {
            this.setMappingsModified();
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Document ").append("uid[").append(this.uid).append("] doc [").append(this.documents).append("]");
        return sb.toString();
    }
}

