/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.PagedBytes;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;

public class PagedBytesAtomicFieldData
extends AbstractAtomicOrdinalsFieldData {
    private final PagedBytes.Reader bytes;
    private final PackedLongValues termOrdToBytesOffset;
    protected final Ordinals ordinals;

    public PagedBytesAtomicFieldData(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset, Ordinals ordinals) {
        this.bytes = bytes;
        this.termOrdToBytesOffset = termOrdToBytesOffset;
        this.ordinals = ordinals;
    }

    @Override
    public void close() {
    }

    @Override
    public long ramBytesUsed() {
        long size = this.ordinals.ramBytesUsed();
        size += this.bytes.ramBytesUsed();
        return size += this.termOrdToBytesOffset.ramBytesUsed();
    }

    @Override
    public RandomAccessOrds getOrdinalsValues() {
        return this.ordinals.ordinals(new ValuesHolder(this.bytes, this.termOrdToBytesOffset));
    }

    private static class ValuesHolder
    implements Ordinals.ValuesHolder {
        private final BytesRef scratch = new BytesRef();
        private final PagedBytes.Reader bytes;
        private final PackedLongValues termOrdToBytesOffset;

        ValuesHolder(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset) {
            this.bytes = bytes;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            assert (ord >= 0L);
            this.bytes.fill(this.scratch, this.termOrdToBytesOffset.get(ord));
            return this.scratch;
        }
    }
}

