/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.LongValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.NumericUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.packed.PackedInts;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AtomicLongFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class PackedArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;
    private final CircuitBreakerService breakerService;

    public PackedArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, IndexNumericFieldData.NumericType numericType, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        Preconditions.checkNotNull(numericType);
        Preconditions.checkArgument(EnumSet.of(IndexNumericFieldData.NumericType.BYTE, IndexNumericFieldData.NumericType.SHORT, IndexNumericFieldData.NumericType.INT, IndexNumericFieldData.NumericType.LONG).contains((Object)numericType), this.getClass().getSimpleName() + " only supports integer types, not " + (Object)((Object)numericType));
        this.numericType = numericType;
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicNumericFieldData loadDirect(AtomicReaderContext context) throws Exception {
        final AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicNumericFieldData data = null;
        PackedArrayEstimator estimator = new PackedArrayEstimator(this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA), this.getNumericType(), this.getFieldNames().fullName());
        if (terms == null) {
            data = AtomicLongFieldData.empty(reader.maxDoc());
            estimator.adjustForNoTerms(data.ramBytesUsed());
            return data;
        }
        PackedLongValues.Builder valuesBuilder = PackedLongValues.monotonicBuilder(0.0f);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        TermsEnum termsEnum = estimator.beforeLoad(terms);
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);){
                BytesRef term;
                boolean indexedAsLong;
                BytesRefIterator iter = builder.buildFromTerms(termsEnum);
                assert (!this.getNumericType().isFloatingPoint());
                boolean bl = indexedAsLong = this.getNumericType().requiredBits() > 32;
                while ((term = iter.next()) != null) {
                    long value = indexedAsLong ? NumericUtils.prefixCodedToLong(term) : (long)NumericUtils.prefixCodedToInt(term);
                    valuesBuilder.add(value);
                }
                final PackedLongValues values = valuesBuilder.build();
                final Ordinals build = builder.build(this.fieldDataType.getSettings());
                IndexFieldData.CommonSettings.MemoryStorageFormat formatHint = IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType);
                RandomAccessOrds ordinals = build.ordinals();
                if (FieldData.isMultiValued(ordinals) || formatHint == IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    long ramBytesUsed = build.ramBytesUsed() + values.ramBytesUsed();
                    data = new AtomicLongFieldData(ramBytesUsed){

                        @Override
                        public SortedNumericDocValues getLongValues() {
                            return PackedArrayIndexFieldData.withOrdinals(build, values, reader.maxDoc());
                        }
                    };
                } else {
                    final FixedBitSet docsWithValues = builder.buildDocsWithValuesSet();
                    long maxV = 0L;
                    long minV = 0L;
                    if (values.size() > 0L) {
                        minV = values.get(0);
                        maxV = values.get(values.size() - 1L);
                    }
                    float acceptableOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_overhead_ratio", Float.valueOf(0.25f)).floatValue();
                    int pageSize = this.fieldDataType.getSettings().getAsInt("single_value_page_size", (Integer)1024);
                    if (formatHint == null) {
                        formatHint = this.chooseStorageFormat(reader, values, build, ordinals, minV, maxV, acceptableOverheadRatio, pageSize);
                    }
                    this.logger.trace("single value format for field [{}] set to [{}]", new Object[]{this.getFieldNames().fullName(), formatHint});
                    switch (formatHint) {
                        case PACKED: {
                            long missingV = 0L;
                            if (docsWithValues != null) {
                                if (maxV - minV + 1L == values.size()) {
                                    if (minV > Long.MIN_VALUE) {
                                        missingV = --minV;
                                    } else {
                                        assert (maxV != Long.MAX_VALUE);
                                        missingV = ++maxV;
                                    }
                                } else {
                                    for (long i = 1L; i < values.size(); ++i) {
                                        if (values.get(i) <= values.get(i - 1L) + 1L) continue;
                                        missingV = values.get(i - 1L) + 1L;
                                        break;
                                    }
                                }
                                missingV -= minV;
                            }
                            final long missingValue = missingV;
                            long maxValue = maxV;
                            final long minValue = minV;
                            long valuesDelta = maxValue - minValue;
                            int bitsRequired = valuesDelta < 0L ? 64 : PackedInts.bitsRequired(valuesDelta);
                            final PackedInts.Mutable sValues = PackedInts.getMutable(reader.maxDoc(), bitsRequired, acceptableOverheadRatio);
                            if (docsWithValues != null) {
                                sValues.fill(0, sValues.size(), missingV);
                            }
                            for (int i = 0; i < reader.maxDoc(); ++i) {
                                ordinals.setDocument(i);
                                if (ordinals.cardinality() <= 0) continue;
                                long ord = ordinals.ordAt(0);
                                long value = values.get(ord);
                                sValues.set(i, value - minValue);
                            }
                            long ramBytesUsed = values.ramBytesUsed() + (docsWithValues == null ? 0L : docsWithValues.ramBytesUsed());
                            data = new AtomicLongFieldData(ramBytesUsed){

                                @Override
                                public SortedNumericDocValues getLongValues() {
                                    if (docsWithValues == null) {
                                        return PackedArrayIndexFieldData.singles(sValues, minValue);
                                    }
                                    return PackedArrayIndexFieldData.sparseSingles(sValues, minValue, missingValue, reader.maxDoc());
                                }
                            };
                            break;
                        }
                        case PAGED: {
                            PackedLongValues.Builder dpValues = PackedLongValues.deltaPackedBuilder(pageSize, acceptableOverheadRatio);
                            long lastValue = 0L;
                            for (int i = 0; i < reader.maxDoc(); ++i) {
                                ordinals.setDocument(i);
                                if (ordinals.cardinality() > 0) {
                                    long ord = ordinals.ordAt(i);
                                    lastValue = values.get(ord);
                                }
                                dpValues.add(lastValue);
                            }
                            long ramBytesUsed = dpValues.ramBytesUsed();
                            final PackedLongValues pagedValues = dpValues.build();
                            data = new AtomicLongFieldData(ramBytesUsed){

                                @Override
                                public SortedNumericDocValues getLongValues() {
                                    return PackedArrayIndexFieldData.pagedSingles(pagedValues, docsWithValues);
                                }
                            };
                            break;
                        }
                        case ORDINALS: {
                            long ramBytesUsed = build.ramBytesUsed() + values.ramBytesUsed();
                            data = new AtomicLongFieldData(ramBytesUsed){

                                @Override
                                public SortedNumericDocValues getLongValues() {
                                    return PackedArrayIndexFieldData.withOrdinals(build, values, reader.maxDoc());
                                }
                            };
                            break;
                        }
                        default: {
                            throw new ElasticsearchException("unknown memory format: " + (Object)((Object)formatHint));
                        }
                    }
                }
                success = true;
                AtomicNumericFieldData atomicNumericFieldData = data;
                return atomicNumericFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!success) {
                estimator.afterLoad(termsEnum, 0L);
            } else {
                estimator.afterLoad(termsEnum, data.ramBytesUsed());
            }
        }
    }

    protected IndexFieldData.CommonSettings.MemoryStorageFormat chooseStorageFormat(AtomicReader reader, PackedLongValues values, Ordinals build, RandomAccessOrds ordinals, long minValue, long maxValue, float acceptableOverheadRatio, int pageSize) {
        long packedDelta = maxValue - minValue + 1L;
        int bitsRequired = packedDelta < 0L ? 64 : PackedInts.bitsRequired(packedDelta);
        PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(reader.maxDoc(), bitsRequired, acceptableOverheadRatio);
        long singleValuesSize = (long)formatAndBits.format.longCount(2, reader.maxDoc(), formatAndBits.bitsPerValue) * 8L;
        long ordinalsSize = build.ramBytesUsed() + values.ramBytesUsed();
        long pagedSingleValuesSize = (reader.maxDoc() / pageSize + 1) * RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        int pageIndex = 0;
        long pageMinOrdinal = Long.MAX_VALUE;
        long pageMaxOrdinal = Long.MIN_VALUE;
        for (int i = 1; i < reader.maxDoc(); ++i) {
            ordinals.setDocument(i);
            if (ordinals.cardinality() > 0) {
                long ordinal = ordinals.ordAt(0);
                pageMaxOrdinal = Math.max(ordinal, pageMaxOrdinal);
                pageMinOrdinal = Math.min(ordinal, pageMinOrdinal);
            }
            if (pageIndex == pageSize - 1) {
                pagedSingleValuesSize += this.getPageMemoryUsage(values, acceptableOverheadRatio, pageSize, pageMinOrdinal, pageMaxOrdinal);
                pageMinOrdinal = Long.MAX_VALUE;
                pageMaxOrdinal = Long.MIN_VALUE;
            }
            pageIndex = (pageIndex + 1) % pageSize;
        }
        if (pageIndex > 0) {
            ++pageIndex;
            pagedSingleValuesSize += this.getPageMemoryUsage(values, acceptableOverheadRatio, pageSize, pageMinOrdinal, pageMaxOrdinal);
        }
        IndexFieldData.CommonSettings.MemoryStorageFormat format = ordinalsSize < singleValuesSize ? (ordinalsSize < pagedSingleValuesSize ? IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS : IndexFieldData.CommonSettings.MemoryStorageFormat.PAGED) : (pagedSingleValuesSize < singleValuesSize ? IndexFieldData.CommonSettings.MemoryStorageFormat.PAGED : IndexFieldData.CommonSettings.MemoryStorageFormat.PACKED);
        return format;
    }

    private long getPageMemoryUsage(PackedLongValues values, float acceptableOverheadRatio, int pageSize, long pageMinOrdinal, long pageMaxOrdinal) {
        long pageMemorySize = 0L;
        if (pageMaxOrdinal == Long.MIN_VALUE) {
            pageMemorySize += RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            long pageMinValue = values.get(pageMinOrdinal);
            long pageMaxValue = values.get(pageMaxOrdinal);
            long pageDelta = pageMaxValue - pageMinValue;
            if (pageDelta != 0L) {
                int bitsRequired = pageDelta < 0L ? 64 : PackedInts.bitsRequired(pageDelta);
                PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(pageSize, bitsRequired, acceptableOverheadRatio);
                pageMemorySize += (long)(formatAndBits.format.longCount(2, pageSize, formatAndBits.bitsPerValue) * 8);
                pageMemorySize += 8L;
            } else {
                pageMemorySize += RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4);
            }
        }
        return pageMemorySize;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    private static SortedNumericDocValues withOrdinals(Ordinals ordinals, final LongValues values, int maxDoc) {
        final RandomAccessOrds ords = ordinals.ordinals();
        final SortedDocValues singleOrds = DocValues.unwrapSingleton(ords);
        if (singleOrds != null) {
            NumericDocValues singleValues = new NumericDocValues(){

                @Override
                public long get(int docID) {
                    int ord = singleOrds.getOrd(docID);
                    if (ord >= 0) {
                        return values.get(singleOrds.getOrd(docID));
                    }
                    return 0L;
                }
            };
            return DocValues.singleton(singleValues, DocValues.docsWithValue(ords, maxDoc));
        }
        return new SortedNumericDocValues(){

            @Override
            public long valueAt(int index) {
                return values.get(ords.ordAt(index));
            }

            @Override
            public void setDocument(int doc) {
                ords.setDocument(doc);
            }

            @Override
            public int count() {
                return ords.cardinality();
            }
        };
    }

    private static SortedNumericDocValues singles(final NumericDocValues deltas, final long minValue) {
        NumericDocValues values = minValue == 0L ? deltas : new NumericDocValues(){

            @Override
            public long get(int docID) {
                return minValue + deltas.get(docID);
            }
        };
        return DocValues.singleton(values, null);
    }

    private static SortedNumericDocValues sparseSingles(final NumericDocValues deltas, final long minValue, final long missingValue, final int maxDoc) {
        NumericDocValues values = new NumericDocValues(){

            @Override
            public long get(int docID) {
                long delta = deltas.get(docID);
                if (delta == missingValue) {
                    return 0L;
                }
                return minValue + delta;
            }
        };
        Bits docsWithFields = new Bits(){

            @Override
            public boolean get(int index) {
                return deltas.get(index) != missingValue;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
        return DocValues.singleton(values, docsWithFields);
    }

    private static SortedNumericDocValues pagedSingles(final PackedLongValues values, final FixedBitSet docsWithValue) {
        return DocValues.singleton(new NumericDocValues(){

            @Override
            public long get(int docID) {
                if (docsWithValue == null || docsWithValue.get(docID)) {
                    return values.get(docID);
                }
                return 0L;
            }
        }, docsWithValue);
    }

    public class PackedArrayEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final CircuitBreaker breaker;
        private final IndexNumericFieldData.NumericType type;
        private final String fieldName;

        public PackedArrayEstimator(CircuitBreaker breaker, IndexNumericFieldData.NumericType type, String fieldName) {
            this.breaker = breaker;
            this.type = type;
            this.fieldName = fieldName;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            return Math.max(this.type.requiredBits() / 10, 4);
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            return new RamAccountingTermsEnum(this.type.wrapTermsEnum(terms.iterator(null)), this.breaker, this, this.fieldName);
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            assert (termsEnum instanceof RamAccountingTermsEnum);
            long estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            this.breaker.addWithoutBreaking(-(estimatedBytes - actualUsed));
        }

        public void adjustForNoTerms(long actualUsed) {
            this.breaker.addWithoutBreaking(actualUsed);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private IndexNumericFieldData.NumericType numericType;

        public Builder setNumericType(IndexNumericFieldData.NumericType numericType) {
            this.numericType = numericType;
            return this;
        }

        public IndexFieldData<AtomicNumericFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new PackedArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, this.numericType, breakerService);
        }
    }
}

