/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.packed.PagedMutable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointCompressedAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class GeoPointCompressedIndexFieldData
extends AbstractIndexGeoPointFieldData {
    private static final String PRECISION_KEY = "precision";
    private static final DistanceUnit.Distance DEFAULT_PRECISION_VALUE = new DistanceUnit.Distance(1.0, DistanceUnit.CENTIMETERS);
    private final CircuitBreakerService breakerService;
    private final GeoPointFieldMapper.Encoding encoding;

    public GeoPointCompressedIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, DistanceUnit.Distance precision, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.encoding = GeoPointFieldMapper.Encoding.of(precision);
        this.breakerService = breakerService;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicGeoPointFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicGeoPointFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA));
        if (terms == null) {
            data = AbstractAtomicGeoPointFieldData.empty(reader.maxDoc());
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        long initialSize = terms.size() >= 0L ? 1L + terms.size() : (long)(1 + Math.min(4096, reader.maxDoc()));
        int pageSize = Integer.highestOneBit(131072 / this.encoding.numBitsPerCoordinate() - 1) << 1;
        PagedMutable lat = new PagedMutable(initialSize, pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
        PagedMutable lon = new PagedMutable(initialSize, pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(terms.size(), reader.maxDoc(), acceptableTransientOverheadRatio);){
                GeoPoint point;
                AbstractIndexGeoPointFieldData.GeoPointEnum iter = new AbstractIndexGeoPointFieldData.GeoPointEnum(builder.buildFromTerms(terms.iterator(null)));
                while ((point = iter.next()) != null) {
                    long ord = builder.currentOrdinal();
                    if (lat.size() <= ord) {
                        long newSize = BigArrays.overSize(ord + 1L);
                        lat = (PagedMutable)lat.resize(newSize);
                        lon = (PagedMutable)lon.resize(newSize);
                    }
                    lat.set(ord, this.encoding.encodeCoordinate(point.getLat()));
                    lon.set(ord, this.encoding.encodeCoordinate(point.getLon()));
                }
                Ordinals build = builder.build(this.fieldDataType.getSettings());
                RandomAccessOrds ordinals = build.ordinals();
                if (FieldData.isMultiValued(ordinals) || IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType) == IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    if (lat.size() != ordinals.getValueCount()) {
                        lat = (PagedMutable)lat.resize(ordinals.getValueCount());
                        lon = (PagedMutable)lon.resize(ordinals.getValueCount());
                    }
                    data = new GeoPointCompressedAtomicFieldData.WithOrdinals(this.encoding, lon, lat, build, reader.maxDoc());
                } else {
                    int maxDoc = reader.maxDoc();
                    PagedMutable sLat = new PagedMutable((long)reader.maxDoc(), pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
                    PagedMutable sLon = new PagedMutable((long)reader.maxDoc(), pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
                    long missing = this.encoding.encodeCoordinate(0.0);
                    for (int i = 0; i < maxDoc; ++i) {
                        ordinals.setDocument(i);
                        long nativeOrdinal = ordinals.nextOrd();
                        if (nativeOrdinal >= 0L) {
                            sLat.set(i, lat.get(nativeOrdinal));
                            sLon.set(i, lon.get(nativeOrdinal));
                            continue;
                        }
                        sLat.set(i, missing);
                        sLon.set(i, missing);
                    }
                    FixedBitSet set = builder.buildDocsWithValuesSet();
                    data = new GeoPointCompressedAtomicFieldData.Single(this.encoding, sLon, sLat, set);
                }
                success = true;
                AtomicGeoPointFieldData atomicGeoPointFieldData = data;
                return atomicGeoPointFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            FieldDataType type = mapper.fieldDataType();
            String precisionAsString = type.getSettings().get(GeoPointCompressedIndexFieldData.PRECISION_KEY);
            DistanceUnit.Distance precision = precisionAsString != null ? DistanceUnit.Distance.parseDistance(precisionAsString) : DEFAULT_PRECISION_VALUE;
            return new GeoPointCompressedIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, precision, breakerService);
        }
    }
}

