/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.packed.PagedMutable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;

public abstract class GeoPointCompressedAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    @Override
    public void close() {
    }

    public static class Single
    extends GeoPointCompressedAtomicFieldData {
        private final GeoPointFieldMapper.Encoding encoding;
        private final PagedMutable lon;
        private final PagedMutable lat;
        private final FixedBitSet set;

        public Single(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat, FixedBitSet set) {
            this.encoding = encoding;
            this.lon = lon;
            this.lat = lat;
            this.set = set;
        }

        @Override
        public long ramBytesUsed() {
            return 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed() + (this.set == null ? 0L : this.set.ramBytesUsed());
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final GeoPoint point = new GeoPoint();
            GeoPointValues values = new GeoPointValues(){

                @Override
                public GeoPoint get(int docID) {
                    Single.this.encoding.decode(Single.this.lat.get(docID), Single.this.lon.get(docID), point);
                    return point;
                }
            };
            return FieldData.singleton(values, (Bits)this.set);
        }
    }

    static class WithOrdinals
    extends GeoPointCompressedAtomicFieldData {
        private final GeoPointFieldMapper.Encoding encoding;
        private final PagedMutable lon;
        private final PagedMutable lat;
        private final Ordinals ordinals;
        private final int maxDoc;

        public WithOrdinals(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat, Ordinals ordinals, int maxDoc) {
            this.encoding = encoding;
            this.lon = lon;
            this.lat = lat;
            this.ordinals = ordinals;
            this.maxDoc = maxDoc;
        }

        @Override
        public long ramBytesUsed() {
            return 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed();
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final RandomAccessOrds ords = this.ordinals.ordinals();
            final SortedDocValues singleOrds = DocValues.unwrapSingleton(ords);
            if (singleOrds != null) {
                final GeoPoint point = new GeoPoint();
                GeoPointValues values = new GeoPointValues(){

                    @Override
                    public GeoPoint get(int docID) {
                        int ord = singleOrds.getOrd(docID);
                        if (ord >= 0) {
                            WithOrdinals.this.encoding.decode(WithOrdinals.this.lat.get(ord), WithOrdinals.this.lon.get(ord), point);
                        } else {
                            point.reset(0.0, 0.0);
                        }
                        return point;
                    }
                };
                return FieldData.singleton(values, DocValues.docsWithValue(singleOrds, this.maxDoc));
            }
            final GeoPoint point = new GeoPoint();
            return new MultiGeoPointValues(){

                @Override
                public GeoPoint valueAt(int index) {
                    long ord = ords.ordAt(index);
                    WithOrdinals.this.encoding.decode(WithOrdinals.this.lat.get(ord), WithOrdinals.this.lon.get(ord), point);
                    return point;
                }

                @Override
                public void setDocument(int docId) {
                    ords.setDocument(docId);
                }

                @Override
                public int count() {
                    return ords.cardinality();
                }
            };
        }
    }
}

