/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IntsRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.FST;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.Util;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.FSTBytesAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class FSTBytesIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    private final CircuitBreakerService breakerService;

    FSTBytesIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache, breakerService);
        this.breakerService = breakerService;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicOrdinalsFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicOrdinalsFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA));
        if (terms == null) {
            data = AbstractAtomicOrdinalsFieldData.empty();
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.Builder<Long> fstBuilder = new org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.Builder<Long>(FST.INPUT_TYPE.BYTE1, outputs);
        IntsRefBuilder scratch = new IntsRefBuilder();
        long numTerms = this.regex == null && this.frequency == null ? terms.size() : -1L;
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(numTerms, reader.maxDoc(), acceptableTransientOverheadRatio);){
                TermsEnum termsEnum = this.filter(terms, reader);
                DocsEnum docsEnum = null;
                BytesRef term = termsEnum.next();
                while (term != null) {
                    long termOrd = builder.nextOrdinal();
                    fstBuilder.add(Util.toIntsRef(term, scratch), termOrd);
                    docsEnum = termsEnum.docs(null, docsEnum, 0);
                    int docId = docsEnum.nextDoc();
                    while (docId != Integer.MAX_VALUE) {
                        builder.addDoc(docId);
                        docId = docsEnum.nextDoc();
                    }
                    term = termsEnum.next();
                }
                FST<Long> fst = fstBuilder.finish();
                Ordinals ordinals = builder.build(this.fieldDataType.getSettings());
                data = new FSTBytesAtomicFieldData(fst, ordinals);
                success = true;
                AtomicOrdinalsFieldData atomicOrdinalsFieldData = data;
                return atomicOrdinalsFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        public IndexOrdinalsFieldData build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new FSTBytesIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

