/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IntsRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IntsRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.FST;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.Util;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;

public class FSTBytesAtomicFieldData
extends AbstractAtomicOrdinalsFieldData {
    protected final Ordinals ordinals;
    private long size = -1L;
    private final FST<Long> fst;

    public FSTBytesAtomicFieldData(FST<Long> fst, Ordinals ordinals) {
        this.ordinals = ordinals;
        this.fst = fst;
    }

    @Override
    public void close() {
    }

    @Override
    public long ramBytesUsed() {
        if (this.size == -1L) {
            long size = this.ordinals.ramBytesUsed();
            this.size = size += this.fst == null ? 0L : this.fst.ramBytesUsed();
        }
        return this.size;
    }

    @Override
    public RandomAccessOrds getOrdinalsValues() {
        return this.ordinals.ordinals(new ValuesHolder(this.fst));
    }

    private static class ValuesHolder
    implements Ordinals.ValuesHolder {
        private final FST<Long> fst;
        private final BytesRefBuilder scratch;
        protected final FST.BytesReader in;
        protected final FST.Arc<Long> firstArc = new FST.Arc();
        protected final FST.Arc<Long> scratchArc = new FST.Arc();
        protected final IntsRefBuilder scratchInts = new IntsRefBuilder();

        ValuesHolder(FST<Long> fst) {
            this.fst = fst;
            this.scratch = new BytesRefBuilder();
            this.in = fst.getBytesReader();
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            assert (ord != -1L);
            this.in.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            try {
                IntsRef output = Util.getByOutput(this.fst, ord, this.in, this.firstArc, this.scratchArc, this.scratchInts);
                this.scratch.clear();
                this.scratch.grow(output.length);
                Util.toBytesRef(output, this.scratch);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.scratch.get();
        }
    }
}

