/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.NumericUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AtomicDoubleFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class DoubleArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData {
    private final CircuitBreakerService breakerService;

    public DoubleArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.DOUBLE;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicNumericFieldData loadDirect(AtomicReaderContext context) throws Exception {
        final AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicNumericFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker(CircuitBreaker.Name.FIELDDATA));
        if (terms == null) {
            data = AtomicDoubleFieldData.empty(reader.maxDoc());
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        DoubleArray values = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            AtomicNumericFieldData atomicNumericFieldData;
            try (OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), acceptableTransientOverheadRatio);){
                BytesRef term;
                BytesRefIterator iter = builder.buildFromTerms(this.getNumericType().wrapTermsEnum(terms.iterator(null)));
                long numTerms = 0L;
                while ((term = iter.next()) != null) {
                    values = BigArrays.NON_RECYCLING_INSTANCE.grow(values, numTerms + 1L);
                    values.set(numTerms++, NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(term)));
                }
                final DoubleArray finalValues = values = BigArrays.NON_RECYCLING_INSTANCE.resize(values, numTerms);
                final Ordinals build = builder.build(this.fieldDataType.getSettings());
                RandomAccessOrds ordinals = build.ordinals();
                if (FieldData.isMultiValued(ordinals) || IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType) == IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    long ramBytesUsed = build.ramBytesUsed() + values.ramBytesUsed();
                    data = new AtomicDoubleFieldData(ramBytesUsed){

                        @Override
                        public SortedNumericDoubleValues getDoubleValues() {
                            return DoubleArrayIndexFieldData.withOrdinals(build, finalValues, reader.maxDoc());
                        }
                    };
                } else {
                    long ordinalsSize;
                    final FixedBitSet set = builder.buildDocsWithValuesSet();
                    long singleValuesArraySize = (long)(reader.maxDoc() * 8) + (set == null ? 0L : RamUsageEstimator.sizeOf(set.getBits()) + 4L);
                    long uniqueValuesArraySize = values.ramBytesUsed();
                    if (uniqueValuesArraySize + (ordinalsSize = build.ramBytesUsed()) < singleValuesArraySize) {
                        long ramBytesUsed = build.ramBytesUsed() + values.ramBytesUsed();
                        success = true;
                        data = new AtomicDoubleFieldData(ramBytesUsed){

                            @Override
                            public SortedNumericDoubleValues getDoubleValues() {
                                return DoubleArrayIndexFieldData.withOrdinals(build, finalValues, reader.maxDoc());
                            }
                        };
                        AtomicDoubleFieldData atomicDoubleFieldData = data;
                        return atomicDoubleFieldData;
                    }
                    int maxDoc = reader.maxDoc();
                    final DoubleArray sValues = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(maxDoc);
                    for (int i = 0; i < maxDoc; ++i) {
                        ordinals.setDocument(i);
                        long ordinal = ordinals.nextOrd();
                        if (ordinal == -1L) continue;
                        sValues.set(i, values.get(ordinal));
                    }
                    assert (sValues.size() == (long)maxDoc);
                    long ramBytesUsed = sValues.ramBytesUsed() + (set == null ? 0L : set.ramBytesUsed());
                    data = new AtomicDoubleFieldData(ramBytesUsed){

                        @Override
                        public SortedNumericDoubleValues getDoubleValues() {
                            return DoubleArrayIndexFieldData.singles(sValues, set);
                        }
                    };
                    success = true;
                }
                success = true;
                atomicNumericFieldData = data;
            }
            return atomicNumericFieldData;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    private static SortedNumericDoubleValues withOrdinals(Ordinals ordinals, final DoubleArray values, int maxDoc) {
        final RandomAccessOrds ords = ordinals.ordinals();
        final SortedDocValues singleOrds = DocValues.unwrapSingleton(ords);
        if (singleOrds != null) {
            NumericDoubleValues singleValues = new NumericDoubleValues(){

                @Override
                public double get(int docID) {
                    int ord = singleOrds.getOrd(docID);
                    if (ord >= 0) {
                        return values.get(singleOrds.getOrd(docID));
                    }
                    return 0.0;
                }
            };
            return FieldData.singleton(singleValues, DocValues.docsWithValue(ords, maxDoc));
        }
        return new SortedNumericDoubleValues(){

            @Override
            public double valueAt(int index) {
                return values.get(ords.ordAt(index));
            }

            @Override
            public void setDocument(int doc) {
                ords.setDocument(doc);
            }

            @Override
            public int count() {
                return ords.cardinality();
            }
        };
    }

    private static SortedNumericDoubleValues singles(final DoubleArray values, FixedBitSet set) {
        NumericDoubleValues numValues = new NumericDoubleValues(){

            @Override
            public double get(int docID) {
                return values.get(docID);
            }
        };
        return FieldData.singleton(numValues, (Bits)set);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new DoubleArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

