/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

abstract class AbstractAtomicParentChildFieldData
implements AtomicParentChildFieldData {
    AbstractAtomicParentChildFieldData() {
    }

    @Override
    public final ScriptDocValues getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return new SortedBinaryDocValues(){
            private final BytesRef[] terms = new BytesRef[2];
            private int count;

            @Override
            public void setDocument(int docId) {
                this.count = 0;
                for (String type : AbstractAtomicParentChildFieldData.this.types()) {
                    SortedDocValues values = AbstractAtomicParentChildFieldData.this.getOrdinalsValues(type);
                    int ord = values.getOrd(docId);
                    if (ord < 0) continue;
                    this.terms[this.count++] = values.lookupOrd(ord);
                }
                assert (this.count <= 2) : "A single doc can potentially be both parent and child, so the maximum allowed values is 2";
                if (this.count > 1) {
                    int cmp = this.terms[0].compareTo(this.terms[1]);
                    if (cmp > 0) {
                        ArrayUtil.swap(this.terms, 0, 1);
                    } else if (cmp == 0) {
                        this.count = 1;
                    }
                }
            }

            @Override
            public int count() {
                return this.count;
            }

            @Override
            public BytesRef valueAt(int index) {
                return this.terms[index];
            }
        };
    }

    public static AtomicParentChildFieldData empty() {
        return new AbstractAtomicParentChildFieldData(){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public SortedDocValues getOrdinalsValues(String type) {
                return DocValues.emptySorted();
            }

            @Override
            public Set<String> types() {
                return ImmutableSet.of();
            }
        };
    }
}

