/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldCache;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.MultiValueMode;

public class FloatValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;
    private final Object missingValue;
    private final MultiValueMode sortMode;
    private final IndexFieldData.XFieldComparatorSource.Nested nested;

    public FloatValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
        this.nested = nested;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.FLOAT;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        final float dMissingValue = ((Float)this.missingObject(this.missingValue, reversed)).floatValue();
        return new FieldComparator.FloatComparator(numHits, null, null, null){

            @Override
            protected FieldCache.Floats getFloatValues(AtomicReaderContext context, String field) throws IOException {
                NumericDoubleValues selectedValues;
                SortedNumericDoubleValues values = ((AtomicNumericFieldData)FloatValuesComparatorSource.this.indexFieldData.load(context)).getDoubleValues();
                if (FloatValuesComparatorSource.this.nested == null) {
                    selectedValues = FloatValuesComparatorSource.this.sortMode.select(values, dMissingValue);
                } else {
                    FixedBitSet rootDocs = FloatValuesComparatorSource.this.nested.rootDocs(context);
                    FixedBitSet innerDocs = FloatValuesComparatorSource.this.nested.innerDocs(context);
                    selectedValues = FloatValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc());
                }
                return new FieldCache.Floats(){

                    @Override
                    public float get(int docID) {
                        return (float)selectedValues.get(docID);
                    }
                };
            }
        };
    }
}

