/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldCache;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.MultiValueMode;

public class DoubleValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;
    private final Object missingValue;
    private final MultiValueMode sortMode;
    private final IndexFieldData.XFieldComparatorSource.Nested nested;

    public DoubleValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
        this.nested = nested;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    protected SortedNumericDoubleValues getValues(AtomicReaderContext context) {
        return ((AtomicNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
    }

    protected void setScorer(Scorer scorer) {
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        final double dMissingValue = (Double)this.missingObject(this.missingValue, reversed);
        return new FieldComparator.DoubleComparator(numHits, null, null, null){

            @Override
            protected FieldCache.Doubles getDoubleValues(AtomicReaderContext context, String field) throws IOException {
                NumericDoubleValues selectedValues;
                SortedNumericDoubleValues values = DoubleValuesComparatorSource.this.getValues(context);
                if (DoubleValuesComparatorSource.this.nested == null) {
                    selectedValues = DoubleValuesComparatorSource.this.sortMode.select(values, dMissingValue);
                } else {
                    FixedBitSet rootDocs = DoubleValuesComparatorSource.this.nested.rootDocs(context);
                    FixedBitSet innerDocs = DoubleValuesComparatorSource.this.nested.innerDocs(context);
                    selectedValues = DoubleValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc());
                }
                return new FieldCache.Doubles(){

                    @Override
                    public double get(int docID) {
                        return selectedValues.get(docID);
                    }
                };
            }

            @Override
            public void setScorer(Scorer scorer) {
                DoubleValuesComparatorSource.this.setScorer(scorer);
            }
        };
    }
}

