/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldComparatorSource;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public interface IndexFieldData<FD extends AtomicFieldData>
extends IndexComponent {
    public FieldMapper.Names getFieldNames();

    public FieldDataType getFieldDataType();

    public FD load(AtomicReaderContext var1);

    public FD loadDirect(AtomicReaderContext var1) throws Exception;

    public XFieldComparatorSource comparatorSource(@Nullable Object var1, MultiValueMode var2, XFieldComparatorSource.Nested var3);

    public void clear();

    public void clear(IndexReader var1);

    public static interface Global<FD extends AtomicFieldData>
    extends IndexFieldData<FD> {
        public IndexFieldData<FD> loadGlobal(IndexReader var1);

        public IndexFieldData<FD> localGlobalDirect(IndexReader var1) throws Exception;
    }

    public static interface Builder {
        public IndexFieldData<?> build(Index var1, @IndexSettings Settings var2, FieldMapper<?> var3, IndexFieldDataCache var4, CircuitBreakerService var5, MapperService var6);
    }

    public static abstract class XFieldComparatorSource
    extends FieldComparatorSource {
        public static final BytesRef MAX_TERM;

        protected final boolean sortMissingFirst(Object missingValue) {
            return "_first".equals(missingValue);
        }

        protected final boolean sortMissingLast(Object missingValue) {
            return missingValue == null || "_last".equals(missingValue);
        }

        protected final Object missingObject(Object missingValue, boolean reversed) {
            if (this.sortMissingFirst(missingValue) || this.sortMissingLast(missingValue)) {
                boolean min = this.sortMissingFirst(missingValue) ^ reversed;
                switch (this.reducedType()) {
                    case INT: {
                        return min ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    }
                    case LONG: {
                        return min ? Long.MIN_VALUE : Long.MAX_VALUE;
                    }
                    case FLOAT: {
                        return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                    }
                    case DOUBLE: {
                        return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    case STRING: 
                    case STRING_VAL: {
                        return min ? null : MAX_TERM;
                    }
                }
                throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
            }
            switch (this.reducedType()) {
                case INT: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).intValue();
                    }
                    return Integer.parseInt(missingValue.toString());
                }
                case LONG: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).longValue();
                    }
                    return Long.parseLong(missingValue.toString());
                }
                case FLOAT: {
                    if (missingValue instanceof Number) {
                        return Float.valueOf(((Number)missingValue).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(missingValue.toString()));
                }
                case DOUBLE: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).doubleValue();
                    }
                    return Double.parseDouble(missingValue.toString());
                }
                case STRING: 
                case STRING_VAL: {
                    if (missingValue instanceof BytesRef) {
                        return (BytesRef)missingValue;
                    }
                    if (missingValue instanceof byte[]) {
                        return new BytesRef((byte[])missingValue);
                    }
                    return new BytesRef(missingValue.toString());
                }
            }
            throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
        }

        public abstract SortField.Type reducedType();

        static {
            BytesRefBuilder builder = new BytesRefBuilder();
            char[] chars = Character.toChars(0x10FFFF);
            builder.copyChars(chars, 0, chars.length);
            MAX_TERM = builder.toBytesRef();
        }

        public static class Nested {
            private final FixedBitSetFilter rootFilter;
            private final FixedBitSetFilter innerFilter;

            public Nested(FixedBitSetFilter rootFilter, FixedBitSetFilter innerFilter) {
                this.rootFilter = rootFilter;
                this.innerFilter = innerFilter;
            }

            public FixedBitSet rootDocs(AtomicReaderContext ctx) throws IOException {
                return this.rootFilter.getDocIdSet(ctx, null);
            }

            public FixedBitSet innerDocs(AtomicReaderContext ctx) throws IOException {
                return this.innerFilter.getDocIdSet(ctx, null);
            }
        }
    }

    public static class CommonSettings {
        public static final String SETTING_MEMORY_STORAGE_HINT = "memory_storage_hint";

        public static MemoryStorageFormat getMemoryStorageHint(FieldDataType fieldDataType) {
            String s = fieldDataType.getSettings().get("ordinals");
            if (s != null) {
                return "always".equals(s) ? MemoryStorageFormat.ORDINALS : null;
            }
            return MemoryStorageFormat.fromString(fieldDataType.getSettings().get(SETTING_MEMORY_STORAGE_HINT));
        }

        public static enum MemoryStorageFormat {
            ORDINALS,
            PACKED,
            PAGED;


            public static MemoryStorageFormat fromString(String string) {
                for (MemoryStorageFormat e : MemoryStorageFormat.values()) {
                    if (!e.name().equalsIgnoreCase(string)) continue;
                    return e;
                }
                return null;
            }
        }
    }
}

