/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;

public class Segment
implements Streamable {
    private String name;
    private long generation;
    public boolean committed;
    public boolean search;
    public long sizeInBytes = -1L;
    public int docCount = -1;
    public int delDocCount = -1;
    public Version version = null;
    public Boolean compound = null;
    public String mergeId;
    public long memoryInBytes;

    Segment() {
    }

    public Segment(String name) {
        this.name = name;
        this.generation = Long.parseLong(name.substring(1), 36);
    }

    public String getName() {
        return this.name;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isSearch() {
        return this.search;
    }

    public int getNumDocs() {
        return this.docCount;
    }

    public int getDeletedDocs() {
        return this.delDocCount;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Version getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean isCompound() {
        return this.compound;
    }

    @Nullable
    public String getMergeId() {
        return this.mergeId;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return !(this.name != null ? !this.name.equals(segment.name) : segment.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static Segment readSegment(StreamInput in) throws IOException {
        Segment segment = new Segment();
        segment.readFrom(in);
        return segment;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.generation = Long.parseLong(this.name.substring(1), 36);
        this.committed = in.readBoolean();
        this.search = in.readBoolean();
        this.docCount = in.readInt();
        this.delDocCount = in.readInt();
        this.sizeInBytes = in.readLong();
        this.version = Lucene.parseVersionLenient(in.readOptionalString(), null);
        this.compound = in.readOptionalBoolean();
        this.mergeId = in.readOptionalString();
        this.memoryInBytes = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.committed);
        out.writeBoolean(this.search);
        out.writeInt(this.docCount);
        out.writeInt(this.delDocCount);
        out.writeLong(this.sizeInBytes);
        out.writeOptionalString(this.version.toString());
        out.writeOptionalBoolean(this.compound);
        out.writeOptionalString(this.mergeId);
        out.writeLong(this.memoryInBytes);
    }

    public String toString() {
        return "Segment{name='" + this.name + '\'' + ", generation=" + this.generation + ", committed=" + this.committed + ", search=" + this.search + ", sizeInBytes=" + this.sizeInBytes + ", docCount=" + this.docCount + ", delDocCount=" + this.delDocCount + ", version='" + this.version + '\'' + ", compound=" + this.compound + ", mergeId='" + this.mergeId + '\'' + ", memoryInBytes=" + this.memoryInBytes + '}';
    }
}

