/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SearcherManager;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.store.Store;

public class EngineSearcher
extends Engine.Searcher {
    private final SearcherManager manager;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final Store store;
    private final ESLogger logger;

    public EngineSearcher(String source, IndexSearcher searcher, SearcherManager manager, Store store, ESLogger logger) {
        super(source, searcher);
        this.manager = manager;
        this.store = store;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ElasticsearchException {
        if (!this.released.compareAndSet(false, true)) {
            this.logger.warn("Searcher was released twice", new ElasticsearchIllegalStateException("Double release"), new Object[0]);
            return;
        }
        try {
            this.manager.release(this.searcher());
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Cannot close", e);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        finally {
            this.store.decRef();
        }
    }
}

