/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.FieldsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.FieldsProducer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.PostingsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.PostingsFormat;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.TermStats;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.TermsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FilterAtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentReadState;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.util.BloomFilter;

@Deprecated
public class BloomFilterPostingsFormat
extends PostingsFormat {
    public static final String BLOOM_CODEC_NAME = "XBloomFilter";
    public static final int BLOOM_CODEC_VERSION = 1;
    public static final int BLOOM_CODEC_VERSION_CHECKSUM = 2;
    public static final int BLOOM_CODEC_VERSION_CURRENT = 2;
    static final String BLOOM_EXTENSION = "blm";
    private BloomFilter.Factory bloomFilterFactory = BloomFilter.Factory.DEFAULT;
    private PostingsFormat delegatePostingsFormat;

    public BloomFilterPostingsFormat(PostingsFormat delegatePostingsFormat, BloomFilter.Factory bloomFilterFactory) {
        super(BLOOM_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public BloomFilterPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    @Override
    public BloomFilteredFieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }

    @Override
    public BloomFilteredFieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BloomFilteredFieldsProducer(state);
    }

    public PostingsFormat getDelegate() {
        return this.delegatePostingsFormat;
    }

    class WrappedTermsConsumer
    extends TermsConsumer {
        private TermsConsumer delegateTermsConsumer;
        private BloomFilter bloomFilter;

        public WrappedTermsConsumer(TermsConsumer termsConsumer, BloomFilter bloomFilter) {
            this.delegateTermsConsumer = termsConsumer;
            this.bloomFilter = bloomFilter;
        }

        @Override
        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            return this.delegateTermsConsumer.startTerm(text);
        }

        @Override
        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            if (stats.docFreq > 0) {
                this.bloomFilter.put(text);
            }
            this.delegateTermsConsumer.finishTerm(text, stats);
        }

        @Override
        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            this.delegateTermsConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
        }

        @Override
        public Comparator<BytesRef> getComparator() throws IOException {
            return this.delegateTermsConsumer.getComparator();
        }
    }

    public final class BloomFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, BloomFilter> bloomFilters = new HashMap<FieldInfo, BloomFilter>();
        private SegmentWriteState state;

        public BloomFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state, PostingsFormat delegatePostingsFormat) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        public FieldsConsumer getDelegate() {
            return this.delegateFieldsConsumer;
        }

        @Override
        public TermsConsumer addField(FieldInfo field) throws IOException {
            BloomFilter bloomFilter = BloomFilterPostingsFormat.this.bloomFilterFactory.createFilter(this.state.segmentInfo.getDocCount());
            if (bloomFilter != null) {
                assert (!this.bloomFilters.containsKey(field));
                this.bloomFilters.put(field, bloomFilter);
                return new WrappedTermsConsumer(this.delegateFieldsConsumer.addField(field), bloomFilter);
            }
            return this.delegateFieldsConsumer.addField(field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, BloomFilter>> nonSaturatedBlooms = new ArrayList<Map.Entry<FieldInfo, BloomFilter>>();
            for (Map.Entry<FieldInfo, BloomFilter> entry : this.bloomFilters.entrySet()) {
                nonSaturatedBlooms.add(entry);
            }
            String bloomFileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, BloomFilterPostingsFormat.BLOOM_EXTENSION);
            IndexOutput bloomOutput = null;
            try {
                bloomOutput = this.state.directory.createOutput(bloomFileName, this.state.context);
                CodecUtil.writeHeader(bloomOutput, BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 2);
                bloomOutput.writeString(BloomFilterPostingsFormat.this.delegatePostingsFormat.getName());
                bloomOutput.writeInt(nonSaturatedBlooms.size());
                for (Map.Entry entry : nonSaturatedBlooms) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    BloomFilter bloomFilter = (BloomFilter)entry.getValue();
                    bloomOutput.writeInt(fieldInfo.number);
                    this.saveAppropriatelySizedBloomFilter(bloomOutput, bloomFilter, fieldInfo);
                }
                CodecUtil.writeFooter(bloomOutput);
            }
            catch (Throwable throwable) {
                IOUtils.close(bloomOutput);
                throw throwable;
            }
            IOUtils.close(bloomOutput);
            this.bloomFilters.clear();
        }

        private void saveAppropriatelySizedBloomFilter(IndexOutput bloomOutput, BloomFilter bloomFilter, FieldInfo fieldInfo) throws IOException {
            BloomFilter.serilaize(bloomFilter, bloomOutput);
        }
    }

    static final class BloomFilteredTermsEnum
    extends TermsEnum {
        private Terms delegateTerms;
        private TermsEnum delegateTermsEnum;
        private TermsEnum reuse;
        private BloomFilter filter;

        public BloomFilteredTermsEnum(Terms other, TermsEnum reuse, BloomFilter filter) {
            this.delegateTerms = other;
            this.reuse = reuse;
            this.filter = filter;
        }

        void reset(Terms others) {
            this.reuse = this.delegateTermsEnum;
            this.delegateTermsEnum = null;
            this.delegateTerms = others;
        }

        private TermsEnum getDelegate() throws IOException {
            if (this.delegateTermsEnum == null) {
                this.delegateTermsEnum = this.delegateTerms.iterator(this.reuse);
            }
            return this.delegateTermsEnum;
        }

        @Override
        public final BytesRef next() throws IOException {
            return this.getDelegate().next();
        }

        @Override
        public final Comparator<BytesRef> getComparator() {
            return this.delegateTerms.getComparator();
        }

        @Override
        public final boolean seekExact(BytesRef text) throws IOException {
            if (!this.filter.mightContain(text)) {
                return false;
            }
            return this.getDelegate().seekExact(text);
        }

        @Override
        public final TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.getDelegate().seekCeil(text);
        }

        @Override
        public final void seekExact(long ord) throws IOException {
            this.getDelegate().seekExact(ord);
        }

        @Override
        public final BytesRef term() throws IOException {
            return this.getDelegate().term();
        }

        @Override
        public final long ord() throws IOException {
            return this.getDelegate().ord();
        }

        @Override
        public final int docFreq() throws IOException {
            return this.getDelegate().docFreq();
        }

        @Override
        public final long totalTermFreq() throws IOException {
            return this.getDelegate().totalTermFreq();
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            return this.getDelegate().docsAndPositions(liveDocs, reuse, flags);
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            return this.getDelegate().docs(liveDocs, reuse, flags);
        }
    }

    public static final class BloomFilteredTerms
    extends FilterAtomicReader.FilterTerms {
        private BloomFilter filter;

        public BloomFilteredTerms(Terms terms, BloomFilter filter) {
            super(terms);
            this.filter = filter;
        }

        public BloomFilter getFilter() {
            return this.filter;
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            if (reuse != null && reuse instanceof BloomFilteredTermsEnum) {
                BloomFilteredTermsEnum bfte = (BloomFilteredTermsEnum)reuse;
                if (bfte.filter == this.filter) {
                    bfte.reset(this.in);
                    return bfte;
                }
                reuse = bfte.reuse;
            }
            BloomFilteredTermsEnum result = new BloomFilteredTermsEnum(this.in, reuse, this.filter);
            return result;
        }
    }

    public final class BloomFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, BloomFilter> bloomsByFieldName = new HashMap();
        private final IndexInput data;

        FieldsProducer getDelegate() {
            return this.delegateFieldsProducer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BloomFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String bloomFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, BloomFilterPostingsFormat.BLOOM_EXTENSION);
            boolean success = false;
            try {
                this.data = state.directory.openChecksumInput(bloomFileName, state.context);
                int version = CodecUtil.checkHeader(this.data, BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 1, 2);
                String delegatePostings = this.data.readString();
                this.delegateFieldsProducer = PostingsFormat.forName(delegatePostings).fieldsProducer(state);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(new Closeable[]{this});
                throw throwable;
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.data, this.delegateFieldsProducer);
        }

        @Override
        public Terms terms(String field) throws IOException {
            BloomFilter filter = this.bloomsByFieldName.get(field);
            if (filter == null) {
                return this.delegateFieldsProducer.terms(field);
            }
            Terms result = this.delegateFieldsProducer.terms(field);
            if (result == null) {
                return null;
            }
            return new BloomFilteredTerms(result, filter);
        }

        @Override
        public int size() {
            return this.delegateFieldsProducer.size();
        }

        @Override
        public long getUniqueTermCount() throws IOException {
            return this.delegateFieldsProducer.getUniqueTermCount();
        }

        @Override
        public long ramBytesUsed() {
            long size = this.delegateFieldsProducer.ramBytesUsed();
            for (BloomFilter bloomFilter : this.bloomsByFieldName.values()) {
                size += bloomFilter.getSizeInBytes();
            }
            return size;
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.delegateFieldsProducer.checkIntegrity();
        }
    }
}

