/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.docvaluesformat;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.DocValuesFormat;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;

public class PreBuiltDocValuesFormatProvider
implements DocValuesFormatProvider {
    private final String name;
    private final DocValuesFormat docValuesFormat;

    public PreBuiltDocValuesFormatProvider(DocValuesFormat postingsFormat) {
        this(postingsFormat.getName(), postingsFormat);
    }

    public PreBuiltDocValuesFormatProvider(String name, DocValuesFormat postingsFormat) {
        Preconditions.checkNotNull(postingsFormat, "DocValuesFormat must not be null");
        this.name = name;
        this.docValuesFormat = postingsFormat;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DocValuesFormat get() {
        return this.docValuesFormat;
    }

    public static final class Factory
    implements DocValuesFormatProvider.Factory {
        private final PreBuiltDocValuesFormatProvider provider;

        public Factory(DocValuesFormat docValuesFormat) {
            this(docValuesFormat.getName(), docValuesFormat);
        }

        public Factory(String name, DocValuesFormat docValuesFormat) {
            this.provider = new PreBuiltDocValuesFormatProvider(name, docValuesFormat);
        }

        public DocValuesFormatProvider get() {
            return this.provider;
        }

        @Override
        public DocValuesFormatProvider create(String name, Settings settings) {
            return this.provider;
        }

        public String name() {
            return this.provider.name();
        }
    }
}

