/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.query.parser.resident;

import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.query.parser.QueryParserCache;
import org.elasticsearch.index.settings.IndexSettings;

public class ResidentQueryParserCache
extends AbstractIndexComponent
implements QueryParserCache {
    private final Cache<QueryParserSettings, Query> cache;
    private volatile int maxSize;
    private volatile TimeValue expire;

    @Inject
    public ResidentQueryParserCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.maxSize = this.componentSettings.getAsInt("max_size", (Integer)100);
        this.expire = this.componentSettings.getAsTime("expire", null);
        this.logger.debug("using [resident] query cache with max_size [{}], expire [{}]", this.maxSize, this.expire);
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().maximumSize(this.maxSize);
        if (this.expire != null) {
            cacheBuilder.expireAfterAccess(this.expire.nanos(), TimeUnit.NANOSECONDS);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public Query get(QueryParserSettings queryString) {
        Query value = this.cache.getIfPresent(queryString);
        if (value != null) {
            return value.clone();
        }
        return null;
    }

    @Override
    public void put(QueryParserSettings queryString, Query query) {
        if (queryString.isCacheable()) {
            this.cache.put(queryString, query);
        }
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public void close() throws ElasticsearchException {
        this.cache.invalidateAll();
    }
}

