/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.docset.simple;

import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.ContextDocIdSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.docset.DocSetCache;
import org.elasticsearch.index.settings.IndexSettings;

public class SimpleDocSetCache
extends AbstractIndexComponent
implements DocSetCache,
AtomicReader.CoreClosedListener {
    private final ConcurrentMap<Object, Queue<FixedBitSet>> cache = ConcurrentCollections.newConcurrentMap();

    @Inject
    public SimpleDocSetCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public void onClose(Object coreCacheKey) {
        this.cache.remove(coreCacheKey);
    }

    @Override
    public void clear(String reason) {
        this.cache.clear();
    }

    @Override
    public void clear(IndexReader reader) {
        this.cache.remove(reader.getCoreCacheKey());
    }

    @Override
    public ContextDocIdSet obtain(AtomicReaderContext context) {
        Queue docIdSets = (Queue)this.cache.get(context.reader().getCoreCacheKey());
        if (docIdSets == null) {
            if (context.reader() instanceof SegmentReader) {
                ((SegmentReader)context.reader()).addCoreClosedListener(this);
            }
            this.cache.put(context.reader().getCoreCacheKey(), ConcurrentCollections.newQueue());
            return new ContextDocIdSet(context, new FixedBitSet(context.reader().maxDoc()));
        }
        FixedBitSet docIdSet = (FixedBitSet)docIdSets.poll();
        if (docIdSet == null) {
            docIdSet = new FixedBitSet(context.reader().maxDoc());
        } else {
            docIdSet.clear(0, docIdSet.length());
        }
        return new ContextDocIdSet(context, docIdSet);
    }

    @Override
    public void release(ContextDocIdSet docSet) {
        Queue docIdSets = (Queue)this.cache.get(docSet.context.reader().getCoreCacheKey());
        if (docIdSets != null) {
            docIdSets.add((FixedBitSet)docSet.docSet);
        }
    }
}

