/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Tokenizer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class StandardTokenizerFactory
extends AbstractTokenizerFactory {
    private final int maxTokenLength;

    @Inject
    public StandardTokenizerFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.maxTokenLength = settings.getAsInt("max_token_length", (Integer)255);
    }

    @Override
    public Tokenizer create(Reader reader) {
        StandardTokenizer tokenizer = new StandardTokenizer(this.version, reader);
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

