/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class StandardAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StandardAnalyzer> {
    private final StandardAnalyzer standardAnalyzer;
    private final Version esVersion;

    @Inject
    public StandardAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.esVersion = Version.indexCreated(indexSettings);
        CharArraySet defaultStopwords = this.esVersion.onOrAfter(Version.V_1_0_0_Beta1) ? CharArraySet.EMPTY_SET : StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords, this.version);
        int maxTokenLength = settings.getAsInt("max_token_length", (Integer)255);
        this.standardAnalyzer = new StandardAnalyzer(this.version, stopWords);
        this.standardAnalyzer.setMaxTokenLength(maxTokenLength);
    }

    @Override
    public StandardAnalyzer get() {
        return this.standardAnalyzer;
    }
}

