/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class SnowballAnalyzerProvider
extends AbstractIndexAnalyzerProvider<SnowballAnalyzer> {
    private static final ImmutableMap<String, CharArraySet> defaultLanguageStopwords = MapBuilder.newMapBuilder().put("English", StopAnalyzer.ENGLISH_STOP_WORDS_SET).put("Dutch", DutchAnalyzer.getDefaultStopSet()).put("German", GermanAnalyzer.getDefaultStopSet()).put("German2", GermanAnalyzer.getDefaultStopSet()).put("French", FrenchAnalyzer.getDefaultStopSet()).immutableMap();
    private final SnowballAnalyzer analyzer;

    @Inject
    public SnowballAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String language = settings.get("language", settings.get("name", "English"));
        CharArraySet defaultStopwords = defaultLanguageStopwords.containsKey(language) ? defaultLanguageStopwords.get(language) : CharArraySet.EMPTY_SET;
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords, this.version);
        this.analyzer = new SnowballAnalyzer(this.version, language, stopWords);
    }

    @Override
    public SnowballAnalyzer get() {
        return this.analyzer;
    }
}

