/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.pattern.PatternReplaceCharFilter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class PatternReplaceCharFilterFactory
extends AbstractCharFilterFactory {
    private final Pattern pattern;
    private final String replacement;

    @Inject
    public PatternReplaceCharFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        if (!Strings.hasLength(settings.get("pattern"))) {
            throw new ElasticsearchIllegalArgumentException("pattern is missing for [" + name + "] char filter of type 'pattern_replace'");
        }
        this.pattern = Pattern.compile(settings.get("pattern"));
        this.replacement = settings.get("replacement", "");
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public Reader create(Reader tokenStream) {
        return new PatternReplaceCharFilter(this.pattern, this.replacement, tokenStream);
    }
}

