/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.pattern.PatternCaptureGroupTokenFilter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class PatternCaptureGroupTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Pattern[] patterns;
    private final boolean preserveOriginal;
    private static final String PATTERNS_KEY = "patterns";
    private static final String PRESERVE_ORIG_KEY = "preserve_original";

    @Inject
    public PatternCaptureGroupTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String[] regexes = settings.getAsArray(PATTERNS_KEY, null, false);
        if (regexes == null) {
            throw new ElasticsearchIllegalArgumentException("required setting 'patterns' is missing for token filter [" + name + "]");
        }
        this.patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            this.patterns[i] = Pattern.compile(regexes[i]);
        }
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIG_KEY, (Boolean)true);
    }

    @Override
    public TokenFilter create(TokenStream tokenStream) {
        return new PatternCaptureGroupTokenFilter(tokenStream, this.preserveOriginal, this.patterns);
    }
}

