/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class LimitTokenCountFilterFactory
extends AbstractTokenFilterFactory {
    public static final int DEFAULT_MAX_TOKEN_COUNT = 1;
    public static final boolean DEFAULT_CONSUME_ALL_TOKENS = false;
    final int maxTokenCount;
    final boolean consumeAllTokens;

    @Inject
    public LimitTokenCountFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.maxTokenCount = settings.getAsInt("max_token_count", (Integer)1);
        this.consumeAllTokens = settings.getAsBoolean("consume_all_tokens", (Boolean)false);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new LimitTokenCountFilter(tokenStream, this.maxTokenCount, this.consumeAllTokens);
    }
}

