/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class LengthTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int min;
    private final int max;
    private final boolean enablePositionIncrements;
    private static final String ENABLE_POS_INC_KEY = "enable_position_increments";

    @Inject
    public LengthTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.min = settings.getAsInt("min", (Integer)0);
        this.max = settings.getAsInt("max", (Integer)Integer.MAX_VALUE);
        if (this.version.onOrAfter(Version.LUCENE_44) && settings.get(ENABLE_POS_INC_KEY) != null) {
            throw new ElasticsearchIllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain or use an older compatibility version (<=4.3) but beware that it might cause highlighting bugs.");
        }
        this.enablePositionIncrements = this.version.onOrAfter(Version.LUCENE_44) ? true : settings.getAsBoolean(ENABLE_POS_INC_KEY, (Boolean)true);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.version.onOrAfter(Version.LUCENE_44)) {
            return new LengthFilter(this.version, tokenStream, this.min, this.max);
        }
        return new LengthFilter(this.version, this.enablePositionIncrements, tokenStream, this.min, this.max);
    }
}

